package LCM::Task::ConvertToMultiDBTask::ConvertToMultiDBTask;

use strict;
use warnings;
use File::Spec;
use File::Basename;
use SDB::Install::NewDBUser;
use SDB::Install::SAPSystemUtilities;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::Globals qw($gLogDir);
use SDB::Install::System qw (isAdmin);
use SDB::Install::Configuration qw($bool_false_pattern);
use LCM::Installer;
use SDB::Install::LayeredConfig;
use LCM::ProcessExecutor;
use LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler;
use SDB::Install::Globals qw ($gHostRoleStreaming);
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';
use LCM::Component::Installed::HDBServer;
use LCM::Utils::CommonUtils;
use SDB::Install::SAPInstance::NameserverUtility;
use LCM::Task::ConvertToMultiDBTask::InitializeSystemUserInMultiDbTask;

my $CONFIGURATION_NAME = 'multitenant database containers';
our $PROGRESS_MESSAGE = "Converting system to $CONFIGURATION_NAME...";
my $SUCCESS_END_MESSAGE = "Finished configuration of $CONFIGURATION_NAME";
my $FAIL_END_MESSAGE = "Configuration of $CONFIGURATION_NAME failed";

our @EXPORT = qw($PROGRESS_MESSAGE);

sub getId {
    return 'convert_to_multidb_task';
}

sub getName {
    return 'Converting to multitenant database containers';
}

sub getExecutionName {
    return 'Converting to multitenant database containers';
}
sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE; 
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $isFinished = $configuration->isServerNoStart()  && !$configuration->hasStreaming() && !$configuration->shallInitializeSystemUserDuringConvertToMDC();
    return $isFinished ? LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED : LCM::Component::Installed::HDBServer::CONVERT_MDC_STARTED;
}
sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    my $currentDepth = defined $progressHandler ? $progressHandler->getIndentationDepth() : 0;
    my $sapSystem = $configuration->getSAPSystem (1);
    my $trexInstance = $configuration->getOwnInstance();
    if(defined $progressHandler){
       $sapSystem->SetProgressHandler   ($progressHandler);
       $trexInstance->SetProgressHandler($progressHandler);
    }
    return  $self->_configure( $sapSystem, $trexInstance);
}

sub _configure {
    my ($self, $sapSystem, $trexInstance) = @_;
    if(!$self->convertToMDC($trexInstance)){
        return undef;
    }

	my $streamingHosts = $self->getSystemHostWithStreamingRole(); 
	for my $host  ( @$streamingHosts ) {
		my $daemon_ini = $trexInstance->readDaemonIni(1,$host);
		$daemon_ini->setValue(CFG_LAYER_HOST, 'streamingserver', 'instances', 0);
	    $daemon_ini->write ();
	} 
    return 1;
}

sub _getNumberOfExpectedOutputLines {
    return 50;
}

sub initProgressHandler {
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

sub convertToMDC{
    my ($self,$trexInstance) = @_;
    my $configuration=$self->_getConfiguration();
    my $newSystemDBSQLPassword =  $configuration->getValue('SystemDBSQLPassword') ;
    my $hdbnsutil =  SDB::Install::SAPInstance::NameserverUtility->new($trexInstance);
    $hdbnsutil->setMsgLstContext($self->getMsgLstContext());
    return $hdbnsutil->convertToMultiDB($newSystemDBSQLPassword);
}

sub getSystemHostWithStreamingRole{
    my ( $self ) = @_;
    my $configuration = $self->_getConfiguration();
    my $trexInstance = $configuration->getOwnInstance(1);
    my $mHostRolesInfo = $trexInstance->getHostRolesInfo();
    my @streamingHosts = ();
    for my $host ( keys %$mHostRolesInfo ) {
        if ( (scalar grep {$_ eq $gHostRoleStreaming} split(" ",$mHostRolesInfo->{$host})) != 0 ) {
            push @streamingHosts, $host;
        }
    }

    return \@streamingHosts;
}

1;