package LCM::Task::DumpConfigfileTemplate::DumpConfigfileTemplateTask;

use strict;
use parent 'LCM::Task';

sub new {
    my ($class, $config, $app) = @_;
    my $self = $class->SUPER::new($config);
    $self->_setApp($app);
    return $self;
}

sub getId {
    return "dump_configfile_template_task";
}

sub getName {
    return "Dump configfile template";
}

sub getExecutionName {
    return "Dump configfile template";
}

sub _setApp {
    my ($self, $app) = @_;
    $self->{app} = $app;
}

sub _getApp {
    my ($self) = @_;
    return $self->{app};
}

sub _executeInternal {
    my ($self) = @_;
    my $app = $self->_getApp();
    my $config = $self->_getConfiguration();
    my $instconfigParams = $config->{params};
    my $actionInstconfigParams = $app->getActionConfiguration()->{params};
    @{$instconfigParams}{keys %$actionInstconfigParams} = values %$actionInstconfigParams;
    $config->clearCachedParamIds();

    if ($app->handleOptionDumpConfigFileTemplate()) {
        $self->getStatus()->_setFinishedState();
    } else {
        $self->getStatus()->_setErrorState();
    }
}

1;