package LCM::Task::GenericStackTask::EnableAutoFailoverTask;

use strict;
use parent 'LCM::Task';

sub getId {
    return 'enable_auto_failover';
}

sub getName{
    return 'Enable Auto-Failover';
}

sub getExecutionName{
    return 'Enabling Auto-Failover';
}

sub _executeInternal {
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $instance = $configuration->getOwnInstance();
    return 0 if (!defined($instance));

    my $message = $self->getMsgLst()->addProgressMessage($self->getExecutionName(). "...");
    my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);

    if($instance->enableAutoFailover($self->getMsgLst())){
        $self->getStatus()->_setFinishedState();
        $message->endMessage (undef, sprintf("%s finished", $self->getName()));
    } else {
        my $sid = $configuration->getSID();
        $self->getStatus()->_setErrorState();
        $message->endMessage (undef, sprintf("%s has failed. " .
            "You need to do it manually by setting the value of '[failover]/enable' " .
            "in '/usr/sap/$sid/SYS/global/hdb/custom/config/nameserver.ini' to 'true' and " .
            "also delete the [failover]/hplm_disabled entry altogether." .
            "Then execute hdbnsutil -reconfig.", $self->getExecutionName()));
    }
    $self->setMsgLstContext($saveContext);
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
    return 1;
}

sub shouldBeShownOnSummaryPage {
    return 0;
}

1;
