package LCM::Task::GenericStackTask::Listeners::PersistUpdateTaskListener;

use strict;
use LCM::PersistencyUtils qw ( existsHdbupdPendingUpdate);
use LCM::Component;
use SDB::Install::Globals qw ($gKeynameEngine);
use SDB::Install::Configuration qw($bool_true_pattern);
use LCM::Configuration::GenericStackAny qw ($ini_section_server);

use parent qw (LCM::Task::GenericStackTask::Listeners::PersistTaskListener);

sub shallRemovePersistenceFile {
	my($self,$task) = @_;

	my $configuration = $task->_getConfiguration();
	my $taskFinished = $task->getStatus()->isInFinishedState() || $task->getStatus()->isInErrorState() || $task->getStatus()->isInAbortedState();

	return 0 if(!$taskFinished);
	if($configuration->isUpdate()){
        my $server = $configuration->getSystemComponentManager()->getComponentByKeyName($gKeynameEngine);
        if (defined $server && $server->isConvertToMDCStarted()){
           return 0;
        }
	}

	if ($configuration->isPrepareUpdate()) {
		return $self->_existsFailedOrAbortedSubtask($task);
	}

	my $existsSelectedCmpInPendingState = $configuration->getComponentManager()->existsSelectedComponentInPendingState($configuration);
	if (!$existsSelectedCmpInPendingState) {
		return 1;
	}

	my $usePhases = $configuration->usePhases();
	my $phase = $task->getPhase();

	if ($self->_isAllSubtasksFinishedSuccessfully($task, 1) && (!$usePhases || $phase eq ONLINE_PHASE)) {
		return 1;
	}

	return 0;
}

sub _existsFailedOrAbortedSubtask {
	my ($self, $task) = @_;
	my $parentTask = $task->getParentTask();

	$parentTask->getSubtasks(); # See implementation of getSubtasks in LCM::Task::GenericStackProcessTask
	for my $subtask (@{$parentTask->getAllSubtasks()}) {
		my $taskStatus = $subtask->getStatus();
		if ($taskStatus->isInErrorState() || $taskStatus->isInAbortedState()) {
			return 1;
		}
	}
	return 0;
}

sub _persistProcessState {
	my ($self, $task) = @_;
	my $configuration = $task->_getConfiguration();

	if ($configuration->isPrepareUpdate() && $self->_isAllSubtasksFinishedSuccessfully($task)) {
		$configuration->setSuccessfullyPreparedUpdate(1);
	} else {
		$configuration->setSuccessfullyPreparedUpdate(undef);
	}
	if($configuration->isUpdate()){
    	my $server = $configuration->getSystemComponentManager()->getComponentByKeyName($gKeynameEngine);
        if (defined $server && $server->isConvertToMDCStarted()){
            $configuration->storeConvertToMDCState(1);
        } else{
            $configuration->storeConvertToMDCState(undef);
        }
	}
	return $self->SUPER::_persistProcessState($task);
}

sub _isAllSubtasksFinishedSuccessfully {
	my ($self, $task, $excludePostTasks) = @_;
	my $parentTask = $task->getParentTask();

	$parentTask->getSubtasks(); # See implementation of getSubtasks in LCM::Task::GenericStackProcessTask
	for my $subtask (@{$parentTask->getAllSubtasks()}) {
		if ($excludePostTasks && ($subtask->isUpdateHostTask() || $subtask->isUpdateLMStructureTask())) {
			next;
		}

		my $taskStatus = $subtask->getStatus();
		if (!$taskStatus->isInFinishedState()) {
			return 0;
		}
	}
	return 1;
}

1;
