package LCM::Task::GenericStackTask::PersistUpdateProcessTask;

use LCM::Task::GenericStackTask::Listeners::PersistUpdateTaskListener;
use strict;
use warnings;
use parent 'LCM::Task';
use LCM::Component qw (ONLINE_PHASE);

sub new{
	my($self) = shift->SUPER::new(@_);
	my $configuration = $self->_getConfiguration();
	$self->addListener(new LCM::Task::GenericStackTask::Listeners::PersistUpdateTaskListener());
    return $self;
}

sub getId {
	return 'persist_process_state';
}

sub getName{
	return 'Persist process state';
}

sub getExecutionName{
	return 'Persisting process state';
}

sub _executeInternal {
	my $self = shift;
	my $configuration = $self->_getConfiguration();
    $self->persistProcessTasks($self->getParentTask(),$configuration);
    $self->getStatus()->_setFinishedState();
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
	return 1;
}

sub shouldBeShownOnSummaryPage {
  return 0;
}


sub persistProcessTasks{
 my ($self,$process,$configuration) = @_;
 my $tasks = $process->getAllSubtasks();
 for my $currentTask(@$tasks){
    $configuration->addExecutionStep($currentTask);
 }
}

sub getPhase{
 return ONLINE_PHASE;
}
1;

