package LCM::Task::GenericStackTask::RemoveComponentPersistencies;
use parent qw (LCM::Task::SHASupportedTask);
use strict;

use LCM::FileUtils qw(listDirectory);
use File::Spec;

sub new {
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();

    $status->_setActionDoneMessage($self->getExecutionName() . ' finished');
    $status->_setActionDoneWithWarningsMessage($self->getExecutionName() . ' finished with warnings');
    $status->_setActionFailedMessage($self->getExecutionName() . ' failed');
    $status->_setActionAbortedMessage($self->getExecutionName() . ' aborted');

    return $self;
}

sub _executeInternal {
    my $self = shift();
    my $configuration = $self->_getConfiguration();

    $self->{message} = $self->getMsgLst()->addProgressMessage($self->getExecutionName() . '...');
    my $message = $self->{message};
    my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);

    my $mcm = $configuration->getMediumComponentManager();
    if (!defined $mcm) {
        return $self->_finishWithError("Failed to get Medium Component Manager", $saveContext);
    }
    my $selectedComponents = $mcm->getSelectedComponents();
    for my $component (@$selectedComponents) {
        next if ($component->isInternal() || $component->isServer() || !$component->hasPersistenceFile($configuration));

        my $cmpSaveContext = $component->setMsgLstContext([$message->getSubMsgLst(), $message->getSubMsgLst()]);
        if (!$component->deletePersistenceFile($configuration)) {
            my $componentName = $component->getComponentName();
            $component->setMsgLstContext($cmpSaveContext);
            return $self->_finishWithError("Failed to delete persistence file of component $componentName", $saveContext);
        }
        $component->setMsgLstContext($cmpSaveContext);
    }
    $configuration->setMsgLstContext([$message->getSubMsgLst(), $configuration->getErrMsgLst()]);
    $configuration->pers_remove();
    $configuration->setMsgLstContext($saveContext);
    return $self->_finishWithSuccess($saveContext);
}

sub _finishWithError {
    my ($self, $err, $saveContext) = @_;
    $self->getMsgLst()->addError($err) if defined $err;
    $self->{message}->endMessage(undef, $self->getExecutionName() . " failed.");
    $self->getStatus()->_setErrorState();
    $self->setMsgLstContext($saveContext) if defined $saveContext;
    return 0;
}

sub _finishWithSuccess {
    my ($self, $saveContext) = @_;
    $self->{message}->endMessage();
    $self->{message}->endMessage(undef, $self->getExecutionName() . " finished.");
    $self->getStatus()->_setFinishedState();
    $self->setMsgLstContext($saveContext) if defined $saveContext;
    return 1;
}

sub getId {
    return 'remove_component_persistencies';
}

sub getSlppLogFileName {
    return 'remove_component_persistencies.log';
}

sub getName {
    return "Remove Leftover Component Persistencies";
}

sub getExecutionName {
    return 'Removing leftover component persistencies';
}

sub _getNumberOfExpectedOutputLines{
    return 5;
}

1;