package LCM::Task::GenericStackTask::UpdateProcessTask;

use parent qw (LCM::Task::GenericStackProcessTask);

use LCM::Task qw($gFlavourProductName $gActionScope);
use SDB::Install::Globals qw($gKeynameEngine);
use strict;
use LCM::Installer;
use LCM::Component qw (PREPARE_PHASE);
use LCM::Task::TaskStatus qw(FINISHED ERROR);
use LCM::Task::GenericStackTask::ComponentExecutionFailedHandler;
use LCM::PersistencyUtils qw (	existsHdblcmPendingUpdate );
use LCM::Task::GenericStackTask::PersistUpdateProcessTask;
use LCM::Task::ConvertToMultiDBTask::ConvertStreamingTask;
use LCM::Task::GenericStackTask::ComponentTasklistFactory::ComponentTasklistFactoryUpdate;
use LCM::Task::DeployXSAComponentsTask;
use LCM::Component::Installable::HDBServer::HDBServerBase;

my $UPDATE_SUCCESS_END_MESSAGE = "$gFlavourProductName $gActionScope updated";
my $UPDATE_FAIL_END_MESSAGE = "Update of $gFlavourProductName $gActionScope failed.";
my $UPDATE_ABORT_END_MESSAGE = "Update of $gFlavourProductName $gActionScope aborted.";

my $PREPARE_UPDATE_SUCCESS_END_MESSAGE = "Update of $gFlavourProductName $gActionScope prepared";
my $PREPARE_UPDATE_FAIL_END_MESSAGE = "Preparing update of $gFlavourProductName $gActionScope failed.";
my $PREPARE_UPDATE_ABORT_END_MESSAGE = "Preparing update of $gFlavourProductName $gActionScope aborted.";

my $UPDATE_CHECK_SUCCESS_END_MESSAGE = "Update checks for the $gFlavourProductName $gActionScope passed";
my $UPDATE_CHECK_FAIL_END_MESSAGE = "Update checks for the $gFlavourProductName $gActionScope failed.";
my $UPDATE_CHECK_ABORT_END_MESSAGE = "Update checks for the $gFlavourProductName $gActionScope aborted.";

sub getId{
    my $self = shift;
    if( $self->_getConfiguration()->getAction() eq 'update' ){
        return 'update_system';
    }
    if( $self->_getConfiguration()->getAction() eq 'update_components' ){
        return 'update_components';
    }
    ...
}

sub getName {
    my $self = shift;
    
    if( $self->_getConfiguration()->getAction() eq 'update' ){
        return 'Update System and Components';
    }
    if( $self->_getConfiguration()->getAction() eq 'update_components' ){
        return 'Install or Update Additional Components'
    }
    ...
}

sub _initActionMessages{
    my($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $status = $self->getStatus();
    if( $configuration->isCheckOnly()) {
        $status->_setActionDoneMessage($self->_formatMessage($UPDATE_CHECK_SUCCESS_END_MESSAGE));
        $status->_setActionDoneWithWarningsMessage("");
        $status->_setActionFailedMessage($self->_formatMessage($UPDATE_CHECK_FAIL_END_MESSAGE));
        $status->_setActionAbortedMessage($self->_formatMessage($UPDATE_CHECK_ABORT_END_MESSAGE));
    } elsif($self->_isPreparePhase() && !existsHdblcmPendingUpdate($configuration->getSID())) {
        $status->_setActionDoneMessage($self->_formatMessage($PREPARE_UPDATE_SUCCESS_END_MESSAGE));
        $status->_setActionDoneWithWarningsMessage("");
        $status->_setActionFailedMessage($self->_formatMessage($PREPARE_UPDATE_FAIL_END_MESSAGE));
        $status->_setActionAbortedMessage($self->_formatMessage($PREPARE_UPDATE_ABORT_END_MESSAGE));
    } else {
        $status->_setActionDoneMessage($self->_formatMessage($UPDATE_SUCCESS_END_MESSAGE));
        $status->_setActionDoneWithWarningsMessage("");
        $status->_setActionFailedMessage($self->_formatMessage($UPDATE_FAIL_END_MESSAGE));
        $status->_setActionAbortedMessage($self->_formatMessage($UPDATE_ABORT_END_MESSAGE));
    }
}

sub isUpdate{
    my $self = shift();
    my $isUpdate = $self->getComponentManager()->isStackUpdate();
    return $isUpdate;   
}

sub getComponentTasklistFactory {
    my ($self, $instconfig) = @_;
    return LCM::Task::GenericStackTask::ComponentTasklistFactory::ComponentTasklistFactoryUpdate->new($instconfig);
}

sub isResumable{
	my ($self) = @_;
	my $configuration = $self->_getConfiguration();

	if (!$configuration->isUpdate()) {
		return 0;
	}

	if ($self->_isOnlyHdblcmCmpSelected()) {
		return 0;
	}

	if(!$configuration->getStep()){
		return 0;
	}

	return 1;
}

sub _createSubtasks{
	my $self = shift();
	$self->SUPER::_createSubtasks(@_);
	
	if(grep {$_->isUpdate()} @{$self->getComponentManager()->getSelectedComponents()}){
        $self->addSubtaskFailedHandler(new LCM::Task::GenericStackTask::ServerUpdateTaskFailedHandler());
        $self->addSubtaskFailedHandler(new LCM::Task::GenericStackTask::ComponentExecutionFailedHandler());
    }
    my $configuration = $self->_getConfiguration();
    if ($configuration->isConvertToMultiDbRequired()) {
        $self->addSubtask(new LCM::Task::GenericStackTask::PersistUpdateProcessTask($configuration));
    }
}

sub _shallAddHosts {
    my $self = shift();
    if($self->_isPreparePhase() && !$self->_getConfiguration()->willExecuteAllComponentsInAllPhases()){
        return 0;
    }
    return $self->SUPER::_shallAddHosts(@_);
}

sub _shallAssignAdditionalLocalRoles{
	my $self = shift();
	if($self->_isPreparePhase() && !$self->_getConfiguration()->willExecuteAllComponentsInAllPhases()){
		return 0;
	}
	return $self->SUPER::_shallAssignAdditionalLocalRoles(@_);
}

sub _shallAssignAdditionalRemoteRoles{
    my $self = shift();
    if($self->_isPreparePhase() && !$self->_getConfiguration()->willExecuteAllComponentsInAllPhases()){
        return 0;
    }
    return $self->SUPER::_shallAssignAdditionalRemoteRoles(@_);
}

sub _shallExecuteUpdateHostOnLocalHost{
    my $self = shift();
    if($self->_isPreparePhase() && !$self->_getConfiguration()->willExecuteAllComponentsInAllPhases()){
        return 0;
    }
    return $self->SUPER::_shallExecuteUpdateHostOnLocalHost(@_);
}

sub _shallExecuteUpdateHostOnRemoteHosts{
    my $self = shift();
    if($self->_isPreparePhase() && !$self->_getConfiguration()->willExecuteAllComponentsInAllPhases()){
        return 0;
    }
    return $self->SUPER::_shallExecuteUpdateHostOnRemoteHosts(@_);
}

sub _isPreparePhase{
	my $self = shift();
	my $configuration =  $self->_getConfiguration();
	return $configuration->usePhases() && $configuration->isPhase(PREPARE_PHASE);
}

sub _addProgressMsg {
    my $self = shift();
    if($self->_isPreparePhase() && !$self->_getConfiguration()->willExecuteAllComponentsInAllPhases()){
        my $action = ($self->isUpdate()) ? 'update' : 'install';
        my $progressMsg =  'Preparing ' . $action . ' of components...';
        my $msg = $self->getMsgLst()->addProgressMessage($progressMsg);
        return 1;
    }
    return $self->SUPER::_addProgressMsg(@_);
}

sub _isServerSelected{
	my($self) = @_;
	return grep {$_->getComponentKeyName() eq $gKeynameEngine} @{$self->getComponentManager()->getSelectedComponents()}
}

1;
