package LCM::Task::HelpProcessTask;

use strict;
use parent 'LCM::Task::SLProcessTask';
use LCM::Task::CLIProcessTaskMetadata;
use LCM::Task::HelpTask::HelpTask;
use LCM::Task::HelpTask::ResidentUpdateSystemHelpTask;
use LCM::Configuration::GenericStackAny qw(UPDATE_ACTION);

sub new {
    my ($class, $config, $app) = @_;
    my $self = $class->SUPER::new($config);
    $self->_setCLIMetadata(LCM::Task::CLIProcessTaskMetadata->new({
        requiresInput           => 0,
        requiresSummary         => 0,
        requiresConfirmation    => 0,
        requiresLog             => 0,
        requiresHeaderMessage   => 0,
        messageBeforeConfirm    => undef,
    }));
    $self->_setApp($app);
    $self->_addSubtasks();
    return $self;
}

sub getId {
    return "show_hdblcm_help_process_task";
}

sub getName {
    return "Display hdblcm help";
}

sub _setApp {
    my ($self, $app) = @_;
    $self->{app} = $app;
}

sub _getApp {
    my ($self) = @_;
    return $self->{app};
}

sub _addSubtasks {
    my ($self) = @_;
    my $app = $self->_getApp();
    my $config = $self->_getConfiguration();
    my $action = $config ? $config->getAction() : '';
    my $isInstalled = LCM::Installer->new()->isInstalled();
    my $isResidentUpdateSystem = ($action eq UPDATE_ACTION) && $isInstalled;

    if ($isResidentUpdateSystem) {
        $self->addSubtask(LCM::Task::HelpTask::ResidentUpdateSystemHelpTask->new($config, $app));
    } else {
        $self->addSubtask(LCM::Task::HelpTask::HelpTask->new($config, $app));
    }
}

## Don't gather SL Analytics data for this action
sub _startSLAnalyticsMonitor {
    return 1;
}

sub _stopSLAnalyticsMonitor {
    return 1;
}

1;