package LCM::Task::HelpTask::ResidentUpdateSystemHelpTask;

use strict;
use parent 'LCM::Task::HelpTask::HelpTask';
use LCM::ComponentManager::MediumComponentManager;
use LCM::FileUtils qw(MyRealPath readFile);
use SDB::Install::Globals qw($gProductName GetServerNotFoundMessage);
use File::Spec;
use File::Basename;

our $KIT_NOT_FOUND_MESSAGE = "$gProductName Installation Kit is required for displaying the complete help,".
                            " but cannot be found in the specified component locations. Specify location which ".
                            "contains $gProductName Installation Kit.";

sub _getUsageString {
    my ($self, $file) = @_;
    my $lines = readFile($file);
    my $hasOutput = defined($lines) && @{$lines};

    return $hasOutput ? join '', @{$lines} : undef;
}

sub _getCommandLineOption {
    my ($self, $option) = @_;
    local @ARGV = @ARGV; # local copy of ARGV
    my $optionSpec = sprintf("%s=s", $option);
    my $optionValue;
    Getopt::Long::GetOptions ($optionSpec => \$optionValue);
    return $optionValue;
}

sub _detectServer {
    my ($self, $config) = @_;

    for my $paramId ('DvdPath', 'ComponentDirs', 'ComponentFsRoot') {
        my $value = $self->_getCommandLineOption($config->getOpt($paramId));
        $config->{params}->{$paramId}->{batchValue} = $value;
    }
    $config->setBatchValueOfRequiredParams('ComponentFsRoot');
    if ($config->errorState()) {
        return 0;
    }
    return 1;
}

sub _getStaticHelpPath {
    my ($self, $config, $app) = @_;
    my $hdblcmPath = $config->getExternalHdblcmPath();
    my $instruntimeDir = $hdblcmPath ? File::Spec->catfile(dirname($hdblcmPath), 'instruntime') : undef;
    my $staticHelpFileName = $app->isPassThroughHelp() ? 'hdblcm_update_passthrough_help.txt' : 'hdblcm_update_help.txt';
    return $instruntimeDir ? File::Spec->catfile($instruntimeDir, $staticHelpFileName) : undef;

}

sub _showHelp {
    my ($self) = @_;
    my $app = $self->_getApp();
    my $config = $self->_getConfiguration(); ## LCM::Configuration::UpdateSystemBootstrapConfiguration
    return 0 if !$self->_detectServer($config);

    my $externalStaticHelpPath = $self->_getStaticHelpPath($config, $app);
    my $usageString = $externalStaticHelpPath ? $self->_getUsageString($externalStaticHelpPath) : undef;
    if (!$usageString) {
        $usageString  = $app->getUsageString(1);
        $usageString .= "\n$KIT_NOT_FOUND_MESSAGE\n";
    }
    $app->PrintText($usageString, 'Usage');
    return 1;
}

sub _executeInternal {
    my ($self) = @_;
    if (!$self->_showHelp()) {
        $self->getStatus()->_setErrorState();
    } else {
        $self->getStatus()->_setFinishedState();
    }
}



1;