package LCM::Task::Hosts::RemoveHosts::UpdateHostsTaskListFactory;

use strict;
use parent qw(LCM::Task::Hosts::BaseUpdateHostsTaskListFactory);
use LCM::SapHostAgentFunctions;
use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::LocalComponentsManager;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager;

sub new{
	my ($class, $configuration) = @_;
	my $self = $class->SUPER::new($configuration);
	return $self;
}

sub _createUpdateLocalHostConfiguration {
	my ($self) = @_;
    my $configuration = $self->getConfiguration();

    my $componentRegistration = 'unregister';
    my $shallRegenerateCertificates = 0;
    my $shallDeployShaConfigurations = 0;
    my $skippedComponents = $configuration->getSkippedComponentsForRegistration(0);
    my $paramHash = {
        ComponentsRegistration => $componentRegistration,
        SkippedComponents => $skippedComponents,
        GenerateCertificates => $shallRegenerateCertificates,
        DeployShaConfigurations => $shallDeployShaConfigurations,
        UpdateComponentListLocation => 0,
    };

    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createLocalConfiguration($configuration, $paramHash);
}

sub _createUpdateRemoteHostConfiguration {
    my($self, $remoteHostsMarkedForRemoval) = @_;
    my $configuration = $self->getConfiguration();

    my $componentRegistration = 'unregister';
    my $shallRegenerateCertificates = 0;
    my $shallDeployShaConfigurations = 0;
    my $skippedComponents = $configuration->getSkippedComponentsForRegistration(1);
    my $remoteHostsObjects = defined($configuration->getRemoteHosts()) ? [ $configuration->getRemoteHosts() ] : [];

    my $paramHash = {
        ComponentsRegistration => $componentRegistration,
        SkippedComponents => $skippedComponents,
        GenerateCertificates => $shallRegenerateCertificates,
        DeployShaConfigurations => $shallDeployShaConfigurations,
        UpdateComponentListLocation => 0,
        SpecificHosts => $remoteHostsMarkedForRemoval
    };

    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createRemoteConfiguration($configuration, $remoteHostsObjects, $paramHash);
}

1;