package LCM::Task::PrintDetectedComponentsProcessTask;

use strict;
use parent qw(LCM::Task::SLProcessTask);
use LCM::Task::CLIProcessTaskMetadata;
use LCM::Task::ComponentList::PrintDetectedComponentsTask;

sub new {
    my ($class, $config) = @_;
    my $self = $class->SUPER::new($config);

    $self->_setCLIMetadata(LCM::Task::CLIProcessTaskMetadata->new({
        requiresInput           => 1,
        requiresSummary         => 0,
        requiresConfirmation    => 0,
        requiresLog             => 0,
        requiresHeaderMessage   => 0,
        messageBeforeConfirm    => undef,
    }));

    return $self;
}

sub getId {
    return "print_detected_components";
}

sub getName {
    return "Print detected components";
}

sub _executeInternal {
    my ($self, $config) = @_;
    $self->_addSubtasks();
    $self->SUPER::_executeInternal($config);
}


sub _addSubtasks {
    my ($self) = @_;
    $self->addSubtask(LCM::Task::ComponentList::PrintDetectedComponentsTask->new($self->_getConfiguration()));
}

## Don't gather SL Analytics data for this action
sub _startSLAnalyticsMonitor {
    return 1;
}

sub _stopSLAnalyticsMonitor {
    return 1;
}

1;