package LCM::Task::RenameTask::CreatePersistenceFileTask;

use strict;
use parent qw(LCM::Task::SHASupportedTask);

my $PROGRESS_MESSAGE = 'Creating Persistence File';
our @EXPORT = qw ($PROGRESS_MESSAGE);

# Override
sub getId {
    return 'create_persistence_file';
}

# Override
sub getName {
    return "Create Persistence File";
}

# Override
sub getExecutionName {
    return $PROGRESS_MESSAGE;
}

# Override
sub _getNumberOfExpectedOutputLines {
    return 100;
}

# Override
sub _executeInternal {
    my $self = shift();
    my $configuration = $self->_getConfiguration();
    
    $self->getMsgLst()->AddMessage($self->getExecutionName() . "..."); 
    if(!$self->_createPersistenceFileIfNeeded($configuration)){
        $self->getStatus()->_setErrorState();
        $self->setErrorMessage(sprintf('%s failed', $self->getName()), $self->getErrMsgLst());
        return;
    }
    $self->getStatus()->_setFinishedState();
}

sub _createPersistenceFileIfNeeded {
    my ( $self, $configuration) = @_;   
    my $hdbInstance = $configuration->getOwnInstance(); 
    my $sid = $configuration->getValue('SID');
    if( $configuration->isSIDChanged() ) {
        $sid = $configuration->getValue ( 'newSID' );
    }
    my $instanceNumber = $configuration->getValue ( 'InstanceNumber' );
    my $localInstanceDir = $configuration->getValue ( 'Target' ) . "/$sid/" . 'HDB' . $instanceNumber;
    my $hosts = $hdbInstance->get_hosts();
    
    for my $host(@{$hosts}){
        my $targetHost = $configuration->{params}->{HostMap}->{value}->{$host};
        my $hostDir = File::Spec->catfile($localInstanceDir, $targetHost);
        if(-d $hostDir){
            my $persistenceFilePath = File::Spec->catfile($localInstanceDir, $targetHost, 'hdblcm_rename_system');
            my $persistenceData = $configuration->_getPersistenceData($hdbInstance);
            $configuration->pers_store($persistenceFilePath, $persistenceData);
            $self->getMsgLst()->addMessage("Created status file '" . $persistenceFilePath . "'");
            next;
        }
    }    
    return 1;
}

1;