package LCM::Task::SHASupportedTask;

use parent qw ( LCM::Task );
use strict;
use SDB::Install::Globals qw ($gLogDir);
use SDB::Install::System qw(isSidadmin);

sub buildSHAOptionsMap {
    my $self = shift();
    my $parameterToOptionMapping = $self->getParameterToOptionMapping();
    my $configuration = $self->_getConfiguration();
    my $optionsMap = {};
    my $params = $configuration->{params};

    for my $param (keys %$params) {
        next if (!exists $parameterToOptionMapping->{$param});

        my $opt = $parameterToOptionMapping->{$param};
        my $isSkipped = $configuration->isSkipped($param);
        my $value = $isSkipped ? undef : $configuration->getValue($param);

        if($configuration->getType($param) =~ /boolean/){
            $value = $value ? 'on' : 'off'; # If no other value is available - explicitly use off
        }
        if (defined($value)){
            $optionsMap->{$opt} = $value;
        }
    }
    my $sid = $self->getSID();
    if ((defined $sid) and (isSidadmin($sid))) {
        my $user = new SDB::Install::NewDBUser($sid);
        my ($uid, $gid) = ($user->uid(), $user->gid());

        if (defined $uid && defined $gid) {
            $optionsMap->{'INSTLOG_UID'} = $uid;
            $optionsMap->{'INSTLOG_GID'} = $gid;
        }
    }
    $optionsMap->{'INSTLOG_DIR'} = $gLogDir;

    return $optionsMap;
}

sub getSID{
	my $self = shift();
	my $configuration = $self->_getConfiguration();
	my $sid = $configuration->getValue('SID');
	if(! defined $sid){
		my $installer = new LCM::Installer();
		if($installer->isInstalled()){
			$sid = $installer->getSid();
		}
    } 
	return $sid;
}

sub getParameterToOptionMapping{
	...
}

sub persistStep {
    my $self = shift();
    return if ! $self->getStatus()->isInFinishedState();

    if($self->canPersistFinishedSteps() && $self->shouldPersistFinishedStep()){
        $self->persistFinishedStep();
    }
}

sub canPersistFinishedSteps {
    my $self = shift();

    my $parentTask = $self->getParentTask();
    return 0 if ! defined $parentTask;

    my $configuration = $parentTask->_getConfiguration();
    return 0 if ! defined $configuration;

    return $configuration->can('addToPersistedFinishedSteps');
}

sub shouldPersistFinishedStep {
    return 0;
}

sub persistFinishedStep {
    my ($self) = @_;

    my $parentTask = $self->getParentTask();
    return 0 if ! defined $parentTask;

    my $configuration = $parentTask->_getConfiguration();
    return 0 if ! defined $configuration;

    $configuration->addToPersistedFinishedSteps($self->getId());
}

sub isSkipped {
    my $self = shift;

    my $parentTask = $self->getParentTask();
    return 0 if ! defined $parentTask;

    my $configuration = $parentTask->_getConfiguration();
    return 0 if ! defined $configuration;

    return 1 if $self->SUPER::isSkipped();
    return 0 if ! $configuration->can('getPersistedSteps');

    my $persistedSteps = $configuration->getPersistedSteps();
    if( defined $persistedSteps ) {
        my $stepName = $self->getStepName();
        return 1 if ( grep( /^$stepName/, split(',', $persistedSteps) ) );
    }

    return 0;
}

1;