package LCM::Task::StartStopHostsTask::StartStopSpecificServicesBase;
use parent 'LCM::Task';
use strict;

sub new {
	my ($class, $configuration, $aServices, $shouldRestartServices) = @_;
	my $self = $class->SUPER::new($configuration);
	$self->setServices($aServices);
	$self->setShouldRestartServices($shouldRestartServices);
	return $self;
}

sub setServices {
	$_[0]->{services} = $_[1];
}

sub getServices {
	return $_[0]->{services};
}

sub setShouldRestartServices {
	$_[0]->{shouldRestart} = $_[1];
}

sub shouldRestartServices {
	return $_[0]->{shouldRestart};
}

sub _executeInternal {
	my ($self) = @_;

	my $message = $self->getMsgLst()->addProgressMessage($self->getExecutionName(). "...");
	my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);

	if ($self->_manageServices()) {
		$self->getStatus()->_setFinishedState();
		$message->endMessage (undef, sprintf("%s finished", $self->getName()));
	} else {
		$self->getStatus()->_setErrorState();
		$message->endMessage (undef, sprintf("%s failed", $self->getName()));
	}

	$self->setMsgLstContext($saveContext);
	return 1;
}

sub _manageServices {
	...
}

sub _getNumberOfExpectedOutputLines {
	return 50;
}

sub shouldBeShownOnSummaryPage {
	return 0;
}

1;
