package LCM::Task::TaskProgressHandler;

use strict;

sub new{
	my ($class, $task) = @_;
	my $self = bless({}, $class);
	$self->_setTask($task);
	$self->{_indentationDepth} = 0;
	return $self;
}

# TODO: FIX AFTER REFACTORING END: Those two subroutines are for compatability - should be discussed

sub addLine{
	$_[0]->SetProgress($_[1]);
}

sub InitProgress ($$$$){
    my ($self,$range,$value,$steps) = @_;
    return 1;
}

sub SetProgress{
	my ($self, $progressMessage) = @_;
	my $outputHandlerKeyFound = $progressMessage =~ s/^(\s*)>/$1/;
    my $indentationDepth = $self->getIndentationDepth();
	if ($outputHandlerKeyFound or
			$progressMessage =~ /(Migrating|Deployment of .* failed|Installation of|Changing listen interface|Installing|Uninstalling|Renaming|Updat\w+|Starting|Stopping|Restarting|Restoring|All server processes|Server processes|Importing|Loading|Uploading|Creating|Adding|Copying|Extracting|Unpacking|Configuring|Launching|Activating|Remov\w+|Registering|Deleting|Unregistering|Regenerating|Deploying|Resum\w+|Prepar\w+|Finaliz\w+|Cleaning|Assigning|supported: SLES|Minimal SLES release|Downloading|Initiating|Performing|Enabling|Disabling|recoverSys.py:|Reverting)\s/){
		$progressMessage = ('  ' x $indentationDepth).$progressMessage;
    	$self->_getTask()->_addProgressMessage($progressMessage);
	}
}

sub _getTask{
	return $_[0]->{_task};
}

sub _setTask{
	my ($self, $task) = @_;
	$self->{_task} = $task;
}

sub getIndentationDepth {
    return shift->{_indentationDepth} // 0;
}

sub setIndentationDepth {
    my ($self, $depth) = @_;
    my $oldValue = $self->{_indentationDepth};
    $self->{_indentationDepth} = $depth;
    return $oldValue;
}

sub incrementIndentationDepth {
    my ($self) = @_;
    my $oldValue = $self->getIndentationDepth();
    $self->setIndentationDepth($oldValue + 1);
}

sub decrementIndentationDepth {
    my ($self) = @_;
    my $oldValue = $self->getIndentationDepth();
    $self->setIndentationDepth($oldValue - 1);
}

1;
