package LCM::Utils::ComponentActionStringGenerator::Uninstall;

use strict;
use LCM::Component;
use SDB::Install::Globals qw ($gKeynameEngine $gKeynameInstaller $gKeynameSDA $gKeynameXS2 $gKeynameLSS);
use parent 'LCM::Utils::ComponentActionStringGenerator';

sub getComponentKeynameToActionMap {
    my ($self, $configuration, $componentManager, $systemComponentManager) = @_;
    my %componentKeynameToAction = ();

    foreach my $component (@{$systemComponentManager->getAllComponents()}){
        next if (!$component->canBeSelectedForUninstall());

        my $componentName = $component->getComponentName();
        my $versionString = $component->getVersion();
        my $keyname = $component->getComponentKeyName();
        $componentKeynameToAction{$keyname} = sprintf('Uninstall %s version %s', $componentName, $versionString);
    }

    my $orderedKeynames = $self->getOrderedKeynames(\%componentKeynameToAction, $componentManager, $systemComponentManager);
    return ( $orderedKeynames, \%componentKeynameToAction );
}

1;