package LCM::Utils::RemoveHosts;

use strict;
use parent qw(Exporter);

our @EXPORT_OK = qw(IsRemovingHost IsRemovingLocalHost IsRemovingRemoteHost IsRemovingHostWithRole IsRemovingAllRemoteHosts);

sub IsRemovingHostWithRole {
    my ($configuration, $hostRole) = @_;
    my $hostsForRemoveCsv = $configuration->getValue('RemoveHosts');

    return 0 if($configuration->isSkipped('RemoveHosts'));
    return 0 if(!$configuration->hasValue('RemoveHosts'));

    my $trexInstance = $configuration->getOwnInstance();
    my $hostRolesInfo = $trexInstance->getHostRolesInfo();

    for my $host (split(',', $hostsForRemoveCsv)){
        my @roles = split('\s+', $hostRolesInfo->{$host});
        if(scalar(grep { $_ =~ /^$hostRole$/} @roles)){
            return 1;
        }
    }
    return 0;
}

sub IsRemovingHost {
    my ($configuration, $targetHost) = @_;
    my $hostsForRemoveCsv = $configuration->getValue('RemoveHosts');

    return 0 if($configuration->isSkipped('RemoveHosts'));
    return 0 if(!$configuration->hasValue('RemoveHosts'));

    for my $host (split(',', $hostsForRemoveCsv)){
        return 1 if($targetHost eq $host);
    }
    return 0;
}

sub IsRemovingLocalHost {
    my ($configuration) = @_;
    my $trexInstance = $configuration->getOwnInstance();
    my $localHost = $trexInstance->get_host();

    return IsRemovingHost($configuration, $localHost);
}

sub IsRemovingRemoteHost {
    my ($configuration) = @_;

    return 0 if(!$configuration->isDistributedSystem());

    my $trexInstance = $configuration->getOwnInstance();
    my $remoteHosts = $trexInstance->get_hosts();

    for my $host (@{$remoteHosts}){
        return 1 if(IsRemovingHost($configuration, $host));
    }
    return 0;
}

sub IsRemovingAllRemoteHosts {
    my ($configuration) = @_;

    return 0 if(!$configuration->isDistributedSystem());

    my $trexInstance = $configuration->getOwnInstance();
    my $remoteHosts = $trexInstance->get_hosts();

    for my $host (@{$remoteHosts}){
        return 0 if(!IsRemovingHost($configuration, $host));
    }
    return 1;
}

1;