package LCM::Utils::TCPUserAgent;

use Errno;
use strict;
use parent 'LWP::UserAgent';
use HTTP::Cookies;
use SDB::Common::Utils qw(toBase64);

my $DEFAULT_REQUEST_TIMEOUT = 20;

sub new {
    my ($class, $caPath, $userDefinedTimoeut) = @_;
    my $timeout = $userDefinedTimoeut || $DEFAULT_REQUEST_TIMEOUT;
    my $sslOptions = {
        'verify_hostname' => 1,
        ( (-d $caPath) ? ('SSL_ca_path' => $caPath) : ('SSL_ca_file' => $caPath) ),
    };
    my $self = $class->SUPER::new('ssl_opts' => $sslOptions, 'cookie_jar' => { hide_cookie2 => 1 } );

    $self->timeout($timeout);
    $self->protocols_allowed(['https']);

    return $self;
}

sub setUser {
    my ($self, $user) = @_;
    $self->{_user} = $user;
}

sub getUser {
    my ($self) = @_;
    return $self->{_user};
}

sub setPassword {
    my ($self, $password) = @_;
    $self->{_password} = $password;
}

sub getPassword {
    my ($self) = @_;
    return $self->{_password};
}

sub setProxyPort {
    my ($self, $port) = @_;
    $self->{_proxyPort} = $port;
}

sub getProxyPort {
    my ($self) = @_;
    return $self->{_proxyPort};
}

sub setProxyHost {
    my ($self, $hostname) = @_;
    $self->{_proxyHost} = $hostname;
}

sub getProxyHost {
    my ($self) = @_;
    return $self->{_proxyHost};
}

sub setProxyUser {
    my ($self, $user) = @_;
    $self->{_proxyUser} = $user;
}

sub getProxyUser {
    my ($self) = @_;
    return $self->{_proxyUser};
}

sub setProxyPassword {
    my ($self, $password) = @_;
    $self->{_proxyPassword} = $password;
}

sub getProxyPassword {
    my ($self) = @_;
    return $self->{_proxyPassword};
}

sub env_proxy {
    my $self = shift();
    local %ENV = %ENV;

    for my $variable (keys(%ENV)){
        next if($variable !~ /_proxy$/i);
        next if($variable =~ /(no|http|https)_proxy/i);

        delete($ENV{$variable}); # Filter out not needed proxy schemas
    }
    $self->SUPER::env_proxy(@_);
}

# Override
sub get {
    my $self = shift();
    return $self->_sendRequest('get', @_);
}

# Override
sub head {
    my $self = shift();
    return $self->_sendRequest('head', @_);
}

sub _sendRequest {
    my ($self, $requestMethod) = (shift(), shift());
    my $response = undef;
    my $proxyURL = $self->_getProxyURL();
    my $user = $self->getUser();
    my $password = $self->getPassword();
    my $proxyUser = $self->getProxyUser();
    my $proxyPassword = $self->getProxyPassword();
    my $authorizationHeader = defined($user) && defined($password) ? sprintf('Basic %s', toBase64("$user:$password")) : undef;
    my $proxyAuthorizationHeader = defined($proxyUser) && defined($proxyPassword) ? sprintf('Basic %s', toBase64("$proxyUser:$proxyPassword")) : undef;
    my $superMethod = sprintf('SUPER::%s', $requestMethod);

    if(defined($proxyURL)) {
        $self->proxy(['http', 'https'], $proxyURL);
    } else {
        $self->env_proxy();
    }

    eval {
        $response = $self->$superMethod(
            @_,
            (defined($authorizationHeader) ? ('Authorization' => $authorizationHeader) : ()),
            (defined($proxyAuthorizationHeader) ? ('Proxy-Authorization' => $proxyAuthorizationHeader) : ()),
        );
    };
    die($@) if($@);

    return $response;
}

sub _getProxyURL {
    my ($self) = @_;
    my $proxyHost = $self->getProxyHost();
    my $proxyPort = $self->getProxyPort();

    return undef if(!defined($proxyHost));
    return undef if(!defined($proxyPort));

    $proxyHost =~ s/\/*$//;
    return sprintf('%s:%s', $proxyHost, $proxyPort);
}

1;