#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Resource module of SDBINST / SDBUPD / sdbunist / sdbregview / sdbverify
#

package SAPDB::Install::Resources;

use SDB::Common::Archive::Tar;
use File::Basename qw (basename);
our %resource_cache;

use Exporter qw(import);
our @EXPORT_OK = qw(getArchiveName);

sub getArchiveName() {
    return 'lcm_res.tgz';
}

sub new {
	my ($type,$archive) = @_;
    if (!defined $archive) {
        $archive = getArchiveName();
    }

	return $resource_cache{$archive} if (exists $resource_cache{$archive});
    my $basename = basename ($archive);
    if (!-f $archive){
        if ($ENV{HDBINST_RESOURCES_TGZ}){
            $archive = $ENV{HDBINST_RESOURCES_TGZ};
        }
        if (!-f $archive){
            $basename = basename ($archive);
            if (-f "$SAPDB::Install::Config{RuntimeDir}/$basename"){
                $archive = "$SAPDB::Install::Config{RuntimeDir}/$basename";
            }
            else{
                die ("Cannot open archive $archive: $!\n");
            }
        }
    }

	my %members;
	$members{'archive'} = $archive;
	$members{'tar'} = SDB::Common::Archive::Tar::new ($archive);
	unless (defined $members{'tar'}) {
		die ("cannot open archive: $archive\n");
	}
	$resource_cache{$basename} = bless(\%members,$type);
	return $resource_cache{$basename};
}

sub readAll {
	my ($self) = @_;
	return undef unless exists $self->{'tar'};
	my $ah = $self->{'tar'};
		
	$ah->rewind ();

	my $bmp_hnd;
	my $png_hnd;

	require Wx;
	for(;;){
		my $name = $ah->read ();
		last unless (defined $name && $name ne '');
		next if (exists $self->{$name} and defined $self->{$name});
		
		next if $name =~ /splash\/MaxDBLogo\.png/; 
		
		if($name =~ /\.bmp$|\.png$/i) {
			my $fh = $ah->open ($name);
			my $img = Wx::Image->new ();

			if ($name =~ /\.png$/i){
				unless(defined $png_hnd){
					$png_hnd = Wx::PNGHandler->new(); 
				}
				my $l = new Wx::LogNull(); # suppress libpng warning popup
				$png_hnd->LoadFile ($img, $fh);
			} elsif ($name =~ /\.bmp$/i) {
				unless(defined $bmp_hnd){
					$bmp_hnd = Wx::BMPHandler->new();
				}
				$bmp_hnd->LoadFile ($img, $fh);
			}
			$self->{$name} = $img;			
		}
	}
	$self->CloseArchive();
}

sub getImages{
	my ($self,@list) = @_;
	my %return_value;
	my @missing;

	foreach my $image (@list){
		if( defined $self->{$image}){
			$return_value{$image} = $self->{$image};
		} else {
			push @missing, $image;
		}
	}

	require Wx;
	if ($#missing >= 0) {
		return undef unless exists $self->{'tar'};
		my $ah = $self->{'tar'};
		$ah->rewind ();

		my $bmp_hnd;
		my $png_hnd;

		for (;;) {
			my $name = $ah->read ();
			last unless (defined $name && $name ne '');

			foreach my $mem (@missing){
				next unless ($name eq $mem);
				my $fh = $ah->open ($name);
				my $img = Wx::Image->new ();
				if($name =~ /\.png$/i){
					unless(defined $png_hnd){
						$png_hnd = Wx::PNGHandler->new(); 
					}
					my $l = Wx::LogNull->new(); # suppress libpng warning popup
					$png_hnd->LoadFile ($img, $fh);
				} 
				else{
					unless(defined $bmp_hnd){
						$bmp_hnd = Wx::BMPHandler->new();
					}
					$bmp_hnd->LoadFile ($img, $fh);
				}
				$self->{$name} = $img;
				$return_value{$name} = $img;
			}
		}
	}

	return \%return_value;
}

sub getData {
	my ($self,@list) = @_;
	my $ah = $self->{'tar'};
	$ah->rewind();
	my %return_value;

	require Wx;
	for(;;){
		my $name = $self->{'tar'}->read ();
		last unless (defined $name && $name ne '');

		foreach my $mem (@list){
			next unless ($name eq $mem);

			my $fh = $ah->open ($name);
			my $img = Wx::Image->new ();

			my $imgdata = $img->GetData ();
			my $height = $img->GetHeight ();
			my $width = $img->GetWidth ();
			$return_value{$mem} = [$imgdata,$width,$height];
		}
	}
	return \%return_value;
}

sub CloseArchive{
	my ($self) = @_;
	if(exists $self->{'tar'}){
		delete $self->{'tar'};
	}
}

1;
