package SDB::Install::App::Console::CopyResidentInstaller;

use base SDB::Install::App::Console;
use LCM::Configuration::GenericStackUpdateConfiguration;
use Getopt::Long;
use SDB::Install::SysVars   qw($isWin $path_separator);
use SDB::Install::System qw (deltree);


use strict;

my ($REMOTE_PATH, $REMOVE_PATH) = (undef, undef);

sub new {
    my $self = shift->SUPER::new ();
    return $self;
}

sub getProgramTitle {
    return "Copy Resident Installer";
}


sub InitApp{
    my ($self) = @_;
    $self->SUPER::InitApp();
    return 1;
}

sub InitCmdLineArgs{
    my ($self,$args) = @_;

    $self->{instconfig} = new LCM::Configuration::GenericStackUpdateConfiguration ($self->{options});

    $self->{action}            = 'Copy Resident Installer';
    $self->{actionProgressive} = 'Copying Resident Installer';
    $self->{actionDone}        = 'Resident Installer copied';

    return $self->SUPER::InitCmdLineArgs ($args);
}

sub copyResidentInstaller {
    my ($self, $remotePath, $removePath) = @_;
    my $rc = 1;
    my $configuration = $self->{instconfig};
    $configuration->CheckParams(1);
    my $sid = $configuration->getSID() || $configuration->getBatchValue('SID');
    if (defined $removePath) {
       my $path = $configuration->getValue ('Target') . $path_separator . $sid . $path_separator . $removePath;
       deltree ($path);
    } else {
       my $path = $configuration->getValue ('Target') . $path_separator . $sid . $path_separator . $remotePath;
       $rc = $configuration->copyInstallerToOtherHosts($path);
    }
    return $rc;
}

sub main{
    my $app = new __PACKAGE__;
    my $rc;

    GetOptions ('remotePath=s' => \$REMOTE_PATH, 'removePath=s' => \$REMOVE_PATH);

    $app->{stackBacktraceMsglst} = new SDB::Install::MsgLst ();
    eval { 
        $app->InitCmdLineArgs(\@ARGV);
        if(defined $app->{'return'}) {
            return $app->{'return'};
        }
        $rc = $app->copyResidentInstaller($REMOTE_PATH, $REMOVE_PATH);
    };

    $app->CleanUp ();

    return defined $rc ? 0 : 1;    
}

sub shouldWarnIfCalledStandalone{
    return 0;
}

1;
