#!/usr/bin/perl
#
# Desc: Performs configuration updates at a remote host caused by hdbupdate.
#       The main method is called by SDB::Install::RemoteHosts::executeParallel
#
# Like hdbrename, the tool repairs the detected configuration problems.


package SDB::Install::App::Console::DBUpgradeHost;

use base SDB::Install::App::Console::HdbRegHost;
use SAPDB::Install::Hostname qw(hostname);

use strict;


#-------------------------------------------------------------------------------
# Constructor
sub new {

    my $self = shift->SUPER::new ();

    return $self;
}


#-------------------------------------------------------------------------------
# Returns the name of this program

sub getProgramName {
    return 'hdbupd_' . lc(hostname());
}


#-------------------------------------------------------------------------------
# Initializes the program and performs several checks.
# Without parameters
# Returns undef in case of an error

sub init {

    my ($self) = @_;

    $self->{instconfig}->setIsSlaveUpgrade ();
    $self->{action}            = 'Update';
    $self->{actionProgressive} = 'Updating';
    $self->{actionDone}        = 'updated';

    return $self->SUPER::init();
}

sub shouldWarnIfCalledStandalone{
    return 0;
}


#-------------------------------------------------------------------------------
# Returns true if the instance should be started after this instance
# is registered.

sub isStartInstance {
    return 0;
}


#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}


1;
