
#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: uninstallation application class

package SDB::Install::App::Console::UpdRep;

use strict;
use SDB::Install::App::Console;
use SDB::Install::SAPSystem;
use SDB::Install::Globals qw ($gProductNameInstaller);
use SDB::Install::Configuration::UpdRep;
use SDB::Install::Log;
use SDB::Install::DebugUtilities;


our @ISA = qw (SDB::Install::App::Console);

sub InitCmdLineArgs{
    my ($self,$args) = @_;
    $self->{instconfig} = new SDB::Install::Configuration::UpdRep (
        $self->{options}, $self->{configfile});
    return $self->SUPER::InitCmdLineArgs ($args);
}

sub init{
    my ($self) = @_;

    my $caption = "$gProductNameInstaller - Update Repository " .$self->GetInstaller->{version};
    my $msglst = $self->getMsgLst ();
    $msglst->addProgressMessage ("\n\n".$caption . "\n" . ('*' x length ($caption)) . "\n\n");

    $self->addStartDateMsg($msglst, $SAPDB::Install::Config{ProgramName});

    my $msg = $msglst->addMessage ("Checking configuration");
    $msg->setEndTag ('Configuration Check');
    my $instconfig = $self->{instconfig};
    $instconfig->setMsgLstContext ([$msg->getSubMsgLst ()]);

    my $rc = $instconfig->CheckParams ($self->{batch_mode});

    if($self->{batch_mode}){
        if (!$rc){
            if (defined $rc){
                $self->setErrorMessage ("Running in batch mode", $instconfig->getErrMsgLst ());
            }
            else{
                $self->setErrorMessage ('Configuration error (batch mode):', $instconfig->getErrMsgLst());
            }
            return undef;
        }
    }
    else{
        if (!$rc && $instconfig->ErrorState ()){
            $self->setErrorMessage ('Configuration error:',$instconfig->getErrMsgLst());
            return undef;
        }
        if (!defined $self->ConfigureInteractive ($instconfig)){
            return undef;
        }
    }
    my $errlst = new SDB::Install::MsgLst ();

    if (!$self->defineLog('UpdateRepository',
                          'hdbupdrep',
                          $instconfig->isCheckOnly(),
                          $instconfig->getSID())) {
        return undef;
    }
    $instconfig->dumpConfigFile('hdbupdrep');

    my $instance = $instconfig->getOwnInstance();
    $instance->setMsgLstContext ($self->getMsgLstContext ());
    my $path = (defined $instconfig->getValue('ContentDir') ? $instconfig->getValue('ContentDir') : $instconfig->getValue('DeliveryUnit'));
    if (!$instance->importDeliveryUnits($instconfig, $path)){
        return undef;
    }
    if (!$instance->importPluginDeliveryUnits ($instconfig)){
        return undef;
    }
    return 1;
}


sub main{
    local @ARGV = @_;
    my $app = new SDB::Install::App::Console::UpdRep();

    $app->InitCmdLineArgs (\@_);

    if (defined $app->{return}){
        LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
        return $app->{return};
    }
    my $rc;
    $app->{stackBacktraceMsglst} = new SDB::Install::MsgLst ();
    eval{
         $rc = $app->init ();
    };
    my $msglst = $app->getMsgLst ();
    if ($@){
        my $signalInfoText;
        if ($@ =~ /^__SIGINT__/){
            $msglst->addMessage ('User canceled update of repository with Ctrl + c');
            $rc = 2;
        }
        elsif ($@ =~ /^__SDB_ABORT__/){
            $msglst->addMessage ('User canceled update of repository');
            $rc = 2;
        }
        elsif ($@ =~ /^__SIGPIPE__/){
            $app->setErrorMessage ('Broken pipe', $app->{stackBacktraceMsglst});
            $signalInfoText = $app->getSignalInfoText ();
            undef $rc;
        }
        elsif ($@ =~ /^__SIG(\w+)__/){
            $app->setErrorMessage ("Caught signal $1", $app->{stackBacktraceMsglst});
            $signalInfoText = $app->getSignalInfoText ();
            undef $rc;
        }
        else{
            $app->setErrorMessage ('unhandled exception: '. $@, $app->{stackBacktraceMsglst});
            $rc = undef;
        }
        if ($signalInfoText){
            $app->appendErrorMessage ($signalInfoText);
        }
    }

    if (defined $rc){
        if ($rc == 2){
            print "\n";
            $msglst->addProgressMessage('Update Repository aborted');
        }
        else{
            $msglst->addProgressMessage('Update Repository done');
        }

    }
    else{
        $app->ShowErrorMsg ('Update Repository failed',$app->getErrMsgLst());
    }
    $app->CleanUp();

    if (defined $app->{return}){
        LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
        return $app->{return};
    }

    undef $app;

    if (defined $rc && $rc != 2) {
		return 0;
    } else {
		return 1;
    }

}

sub shouldWarnIfCalledStandalone{
    return 0;
}

1;
