#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 
#

package SDB::Install::App::Gui::Installation;

use SDB::Install::App::Gui;
use SDB::Install::App::Installation;
use SDB::Install::Kit;
use SDB::Install::Globals;
use SDB::Install::Log;
use SDB::Install::Gui::Frame::StartSetup;
use Getopt::Long;
use strict;

our @ISA = qw (SDB::Install::App::Gui SDB::Install::App::Installation);


sub new{
    return shift->SUPER::new ();
}

sub InitCmdLineArgs{
    my ($self,$args) = @_;
    if (!defined $self->{options}){
        $self->{options} = {};
    }
    local %SIG = %SIG;
    my $errtext;
    $SIG{__WARN__} = sub{
        print STDERR $_[0];
        $self->appendErrorMessage ($_[0]);
    };

    my $rc = $self->SUPER::InitCmdLineArgs ($args, 1);

    if (!defined $rc){
        return undef;
    }

    $rc = $self->ParseInstallationCmdLineArgs ($rc, 1);
    
    if (!defined $rc){
        return undef;
    }

    if (!defined $self->init ()){
        return undef;
    }

    if (defined $self->{return}){
        return undef;
    }

    if ($self->{kit}->isServer()){

        my %opt_ctrl = (
            'action=s' => \$self->{options}->{action}
        );

        local *ARGV = $rc;
        if (!defined $self->getOptions (\%opt_ctrl, 1)){
           return undef;
        }
        if (defined $self->{options}->{action}){
            if ($self->{options}->{action} eq 'install'){
                $rc =  $self->ParseInstallationCmdLineArgs ($rc);
                if (!defined $rc){
                    return undef;
                }
            }
            elsif ($self->{options}->{action} eq 'update'){
                $self->{instconfig} = new SDB::Install::Configuration::Upgrade
                    ($self->{options}, $self->{configfile});
            }
            else{
                my $msglst = new SDB::Install::MsgLst ();
                $self->setErrorMessage ("Invalid argument of option --action");
                $self->setErrorMessage ("Wrong Usage", $self->getErrMsgLst());
                return undef;
            }
            $self->{_config_selected} = 1;
        }
    }

    my $hasConfig = !$self->{kit}->isServer() || $self->{_config_selected};

    if ($hasConfig){
        if ($self->isHelp()) {
            $self->PrintUsage ();
            $self->{return} = 0 ;
            return undef;
        }
        $rc = $self->ParseConfigCmdLineArgs ($rc);
        if (!defined $rc){
            return undef;
        }
       if (!defined $self->checkSystemRequirements ()){
            return undef;
       }
    }

    local @ARGV = @$rc if defined $rc;

    if (! defined $self->getOptions ({}, !$hasConfig)){
        $self->{return} = -1;
        return undef;
    }
    return $rc;
}

sub InitApp{
    my ($self) = @_;

    $self->SUPER::InitApp();

    $self->{log}->setIndicateLocationOnStdout(LOG_DONT_INDICATE_LOCATION_ON_STDOUT);
    return 1;
}


#-------------------------------------------------------------------------------
# Returns a reference to an array of arrays
# containg the description of batch and help options.

sub GetBatchHelpUsage {

    my $usage = [['--help',    '-h', 'Displays the help information'],
                 ['--version', '-v', "Displays the version of $SAPDB::Install::Config{ProgramName}"]];

    return  $_[0]->GetInstallationBatchHelpUsage($usage);
}


#-------------------------------------------------------------------------------
# Returns a refrence to an empty array.

sub GetBatchSwitches{
    return [];
}


#-------------------------------------------------------------------------------
# Returns a reference to an array containing help/info options of the program.

sub GetHelpSwitches{
    my ($self, $indent)= @_;
    return $self->GetInstallationHelpSwitches($indent);
}


#-------------------------------------------------------------------------------
# Returns a reference to an array containing hdbinst options
# without help/info options.

sub GetSwitches{

    return $_[0]->GetInstallationSwitches();
}


#-------------------------------------------------------------------------------
# Returns a reference to an array of arrays containg the description
# of hdbinst options without common help options.

sub GetUsage{
    return shift->GetInstallationUsage(@_);
}


sub getFrameWindow{
    my ($self) = @_;
    my $title = "$gProductNameInstaller [" . $self->GetInstaller()->GetVersion . ']' ;
    return (new SDB::Install::Gui::Frame::StartSetup ($title,
        [100, 100], #start-position
        [-1, -1] #has no effect
        ));
}

sub CleanUp{
    my ($self) = @_;
    return $self->SDB::Install::App::Installation::CleanUp ();
}



#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    my $rc;
    $app->{stackBacktraceMsglst} = new SDB::Install::MsgLst ();
    eval{
        my @copy = @_;
        $rc = $app->InitCmdLineArgs (\@copy);
        if (!defined $rc){
           return undef;
        }
        if (defined $app->{return}){
            return $app->{return};
        }
       $app->startMainLoop ();
    };

    if (defined $app->{return}){
        return $app->{return};
    }

    $rc = $app->handleReturnCodes($@, $rc);

    $app->CleanUp ();

    undef $app;

    return defined $rc ? 0 : 1;
}
1;

