package SDB::Install::CloudEditionUpdateCheck;

use strict;
use warnings;

use parent 'SDB::Install::Base';


sub new{
    my $self = shift->SUPER::new();
    ($self->{srcManifest}, $self->{tgtManifest}) = @_;
    return $self;
}

sub isCloudEditionVersionCheckRequired{
    my ($self) = @_;
    my $srcCloudEditionVersion = $self->{srcManifest}->getCloudEditionVersionObject();
    if (!defined $srcCloudEditionVersion){
        return 0;
    }
    my $tgtCloudEditionVersion = $self->{tgtManifest}->getCloudEditionVersionObject();
    if (!defined $tgtCloudEditionVersion){
        return 0;
    }
    my $srcVersion = $self->{srcManifest}->getVersionObjectWithoutRevChangeList();
    my $tgtVersion = $self->{tgtManifest}->getVersionObjectWithoutRevChangeList();
    if (!$srcVersion->isEqual($tgtVersion)){
        return 0;
    }
    return 1;
}

sub canUpdate{
    my ($self) = @_;
    my $srcCloudEditionVersion = $self->{srcManifest}->getCloudEditionVersionObject();
    my $tgtCloudEditionVersion = $self->{tgtManifest}->getCloudEditionVersionObject();
    if ($srcCloudEditionVersion->isNewerThan($tgtCloudEditionVersion)){
        $self->setErrorMessage("Newer Cloud Edition Version (".$srcCloudEditionVersion->asString().") is already installed.");
        return 0;
    }
    $self->getMsgLst()->addMessage('Upgrade from Cloud Edition ' .$srcCloudEditionVersion->asString() .
        ' to ' . $tgtCloudEditionVersion->asString(). ' is allowed.');
    return 1;
}

1;