package SDB::Install::Configuration::Container::HdbContainerConfig;

use base SDB::Install::Configuration::AnyConfig;

use strict;


sub new {
    my $self = shift->SUPER::new (@_);

    return $self;
}

sub getParamAction {
    my ( $self, $order, $section ) = @_;

    my %param = (
        'order'                       => $order++,
        'opt'                         => 'action',
        'type'                        => 'string',
        'section'                     => $section,
        'value'                       => undef,
        'str'                         => 'Action',
        'desc'                        => 'Specifies the action to be performed',
        'mandatory'                   => 1,
        'valid_values'                => ['init_persistence', 'initial_start', 'init_ssfs',
                                          'update_container', 'check_container', 'activate_plugins',
                                          'check_update'],
    );

    return \%param;
}

sub getParamComponents {
    my ( $self, $order, $section ) = @_;

    my %param = (
        'order'                       => $order,
        'opt'                         => 'components',
        'opt_arg'                     => 'all|<comp1>[,<comp2>]...',
        'type'                        => 'csv',
        'section'                     => $section,
        'value'                       => undef,
        'str'                         => 'Components',
        'desc'                        => 'Components',
        'mandatory'                   => 0,
    );

    return \%param;
}

sub getParamDefaultTenantSystemUserPassword {
    my ($self, $order, $section) = @_;

    my %param = (
        'order'             => $order,
        'opt'               => 'default_tenant_system_user_password',
        'type'              => 'passwd',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'str'               => 'Default Tenant Database System User Password',
        'init_with_default' => 0,
        'log_value'         => sub {defined $_[0] ? '***' : '<not defined>';},
        'mandatory'         => 1,
    );

    return \%param;
}

sub getParamSystemDatabaseSystemUserPassword {
    my ($self, $order, $section) = @_;

    my %param = (
        'order'             => $order,
        'opt'               => 'system_user_password',
        'type'              => 'passwd',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'str'               => 'System Database System User Password',
        'init_with_default' => 0,
        'log_value'         => sub {defined $_[0] ? '***' : '<not defined>';},
        'mandatory'         => 1,
    );

    return \%param;
}

sub getParamTenantDatabaseSqlPort {
    my ($self, $order, $section) = @_;

    my %param = (
        'order'             => $order,
        'opt'               => 'tenant_port',
        'type'              => 'number',
        'section'           => $section,
        'value'             => undef,
        'str'               => 'Tenant Database Sql Port',
        'mandatory'         => 0,
    );

    return \%param;
}

sub getParamCreateInitialTenant {
    my ($self, $order, $section) = @_;

    my %param = (
        'order'             => $order,
        'opt'               => 'create_initial_tenant',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 1,
        'init_with_default' => 1,
        'str'               => 'Create Initial Tenant',
        'mandatory'         => 0,
    );

    return \%param;
}

1;
