package SDB::Install::Configuration::GenericSystemComponent;

use strict;
use SDB::Install::Configuration::Generic;
use SDB::Install::SysVars;
use SDB::Install::SAPSystem;
use SDB::Install::Globals qw ($gProductNameSystem $gProductNameEngine);

our $installationClass = 'SDB::Install::Installation::Generic';
our $kitClass = 'SDB::Install::Kit::Generic';

our @ISA = qw (SDB::Install::Configuration::Generic);

sub getInstallationClass{
    return $installationClass;
}

sub getKitClass{
    return $kitClass;
}

sub new{
	my $self = shift->SUPER::new (@_);
	my $order = 0;

	$self->{params} = {
		'SID' => {
			'order' => $order++,
			'opt' => 'sid',
			'short_opt' => 's',
			'type' => 'string',
			'value' => undef,
			'default' => undef,
			'str' => "$gProductNameSystem ID",
            'opt_arg' => '<SID>',
			'mandatory' => 1
		}
	};
	return $self;
}

sub InitDefaults{
    my ($self, $kit) = @_;
    $self->SUPER::InitDefaults ($kit);
    my $systems = CollectSAPSystems ();
    if (!defined $systems){
        return 1;
    }
    my @sids;
    my @ui_values;
    my $sys;
    my $latest;
    my $mtime;
    my $instreg;
    foreach my $sid (sort keys (%$systems)){
        $sys = $systems->{$sid};
        my $instreg = $sys->getRegistryPath() . $path_separator . 'INSTREG';
        $mtime = (stat ($instreg))[9];
        if (!$latest){
            $latest = [$sid, $mtime];
        }
        else{
            if ($latest->[1] < $mtime){
                $latest = [$sid, $mtime];
            }
        }

        if ($sys->hasNewDB()){
            push @sids, $sid;
            push @ui_values, $gProductNameEngine .' ' . $sid . ' ' . $sys->GetVersion();
        }
    }
    if (@sids){
        $self->setDefault('SID', $latest->[0]);
        $self->{params}->{SID}->{valid_values} = \@sids;
        $self->{params}->{SID}->{ui_values} = \@ui_values;
    }
    return 1;
}


sub checkSID{
	my ($self, $value) = @_;
	my $properties = $self->{params}->{SID};

	if ($value !~ /^[A-Z][A-Z0-9][A-Z0-9]$/){
		$self->AddError ("Invalid $properties->{str}");
		return 0;
	}

	my $systems = CollectSAPSystems ();

	if (!exists $systems->{$value}){
		$self->AddError ("$properties->{str} \"$value\" " .
							"not found");
		return 0;
	}

	my $system = $systems->{$value};

	if (!$system->hasNewDB()){
			if ($system->hasTrex()){
				my $path = join ($path_separator,$system->{_usrSapSid},qw (SYS global trex install bin hdbuninst));
				if ($isWin){
					$path .= '.exe';
				}
				$self->AddError ("Cannot upgrade old NewDB instance (incompatible file system changes).");
				$self->PushError ("Please uninstall it using '$path' and reinstall it afterwards!");
			}
			else{
				$self->AddError ("$properties->{str} \"$value\" " .
					"has no $gProductNameEngine instance");
			}
			return 0;
	}

	#
	# checking if there is a new installation, which isn't finished yet
	#

	my $origin_class = ref ($self);
	bless ($self, 'SDB::Install::Configuration::NewDB');
	my $newinstallation_pending = $self->pers_exists ();
	bless ($self,$origin_class);
	if ($newinstallation_pending){
		$self->AddError ("The initial installation of $gProductNameEngine $value is pending. (" . $self->pers_date_string () . ")");
		$self->PushError ("Please resume server installation.");
		return 0;
	}

	return 1;
}

sub getSystem{
	my $self = $_[0];
	my $sid = $self->getValue ('SID');
	my $systems = CollectSAPSystems ();
	my $system = $systems->{$sid};
	return $system;
}

sub getSharedDirectory{
	# returns <hanamnt>
	my $self = $_[0];
	my $system = $self->getSystem();
	return $system->get_target();
}


sub getSharedDirectorySID{
	# returns <hanamnt>/<SID>/
	my $self = $_[0];
	my $system = $self->getSystem();
	return $system->get_globalSidDir();
}

sub getHDBInstance{
    my ($self) = @_;
    my $sys = $self->getSystem ();
    return $sys->getNewDBInstances ()->[0];
}

sub getHDBInstanceNr{
    my ($self) = @_;
    my $instance = $self->getHDBInstance ();
    return $instance->get_nr();
}

sub getHDBHostName{
    my ($self) = @_;
    my $instance = $self->getHDBInstance ();
    return $instance->get_host ();
}

sub getHDBRemoteHostNames{
    my ($self) = @_;
    my $instance = $self->getHDBInstance ();
    return $instance->get_hosts ();
}


sub get_InstallationPath{
	# returns installation path for :
	# <hanamnt>/<SID>/<productKey>
	my $self = $_[0];
	return $self->getSharedDirectorySID() . $path_separator . $self->{productKey};
}

sub getReplaceHash{
	my $self = shift;
	my $result = $self->SUPER::getReplaceHash(@_);
	$result->{'%(INSTANCE_NR)'} = $self->getHDBInstanceNr ();
	$result->{'%(HOSTNAME)'} = $self->getHDBHostName ();
	$result->{'%(SAPMNT)'} = $self->getSharedDirectorySID();
	$result->{'%(InstallationPath)'} = $self->get_InstallationPath();
	return $result;
}

sub get_UID{
	return $_[0]->getSystem()->getUID();
}

sub get_GID{
	return $_[0]->getSystem()->getGID();
}

sub setUpdateParams{
	return 1;
}


1;
