package SDB::Install::Configuration::HdbClientReg;

use strict;

use SAPDB::Install::Hostname qw(hostname);
use SDB::Install::Configuration::AnyConfig;
use SDB::Install::SysVars    qw($path_separator);
#use SDB::Install::DebugUtilities qw(dumpThings);

our @ISA = qw (SDB::Install::Configuration::AnyConfig);

our $section           = 'Config';
our $peristentFileName = 'hdbclientreg';

# Hash keys of this class: 'Unregister'       (int 1 / undef)


#-------------------------------------------------------------------------------

sub new {
    my $self = shift->SUPER::new (@_);
    my $order = 0;
    $self->{'params'} = {
        'Unregister' => {
                'order'             => $order++,
                'opt'               => 'unregister',
                'short_opt'         => 'u',
                'type'              => 'boolean',
                'section'           => $section,
                'value'             => undef,
                'default'           => 0,
                'str'               => 'Unregister',
                'hidden'            => 0,
                'set_interactive'   => 0,
                'init_with_default' => 1,
                'mandatory'         => 0
        }
    };
    return $self;
}


#-------------------------------------------------------------------------------
# Initializes default values
#
# Returns int retCode

sub InitDefaults {
    my ($self) = @_;
    if (!defined $self->SUPER::InitDefaults()) {
        return undef;
    }
    return 1;
}


#-------------------------------------------------------------------------------
# Returns undef (hdbclientreg does not start or stop a SAP HANA instance)

sub getTimeoutValues{
    return undef;
}


#-------------------------------------------------------------------------------

1;

