package SDB::Install::Configuration::Uninstallation::GenericServerPlugin;

use strict;
use warnings;

use SDB::Install::Globals qw($gProductNameEngine $gServerPluginParametersConstraint);
use SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation::AflOnlineUninstallation;

use parent 'SDB::Install::Configuration::GenericUninstallation';

our $section = 'afl';


sub prependParams{
    my ($self) = @_;
    my $params = $self->{params};
    my $order = 0;
    my $orderedParamIds = $self->getParamIds();
    $params->{'NoRestart'} = $self->getParamNoRestart($order++, $section, $gServerPluginParametersConstraint);
    foreach my $paramId (@$orderedParamIds){
        $params->{$paramId}->{order} = $order++;
    }
    $self->clearCachedParamIds();
    return 1;
}

sub appendParams{
    my ($self) = @_;
    my $params = $self->{params};
    my $orderedParamIds = $self->getParamIds();
    my $lastParamId = pop @$orderedParamIds;
    my $order = $params->{$lastParamId}->{order} + 1;
    $params->{'SystemUser'}   = $self->getParamSystemUser($order++, $section);
    $params->{'SQLSysPasswd'}  = $self->getParamSQLSysPasswd($order++, $section, 'passwd', 0);
    $self->clearCachedParamIds();
    return 1;
}

sub getOnlineRegistrationHandler{
    return $_[0]->{_onlineRegistrationHandler};
}

sub getParamNoRestart{
    my ($self, $order, $section, $constraint) = @_;

    return {
        'order'             => $order,
        'opt'               => 'norestart',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'str'               => "Skip system restart when uninstalling $gProductNameEngine Plugins",
        'init_with_default' => 1,
        'set_interactive'   => 0,
        'constraint'        => $constraint,
    };
}

sub initInstallation{
    my ($self, $installation) = @_;

    $self->setSkip('SystemUser', 1);
    $self->setSkip('SQLSysPasswd', 1);

    if (!defined $self->SUPER::initInstallation($installation)){
        return undef;
    }

    my $isOnlineUpdatable = $self->isOnlineUpdatable($installation);

    $self->setSkip('NoRestart', 0);
    my $system   = $installation->getSystem();
    return 1 if (!defined $system);
    my $instance = $system->getNewDBInstances()->[0];
    return 1 if (!defined $instance);
    $self->{ownInstance} = $instance;
    if ($self->isDistributedSystem() && !$isOnlineUpdatable){
        $self->setSkip('Password', 0);
    }

    if ($isOnlineUpdatable && $system->_isRunning($self)){
        $self->setSkip('SystemUser', 0);
        $self->setSkip('SQLSysPasswd', 0);
    }
    return 1;
}

sub isOnlineUpdatable{
    my ($self, $installation) = @_;
    if (!defined $self->{_onlineUpdatable}){
        if (!defined $installation){
            $self->setErrorMessage('Server Plugin installation object is not defined');
            return undef;
        }
        my $onlineRegistrationHandler =
            new SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation::AflOnlineUninstallation(
                $installation->getProductKey(),
                $installation->getManifest());
        $onlineRegistrationHandler->setMsgLstContext([$self->getMsgLst()]);
        $self->{_onlineUpdatable} = $onlineRegistrationHandler->checkPreconditionOffline();
        if ($self->{_onlineUpdatable}){
            $self->{_onlineRegistrationHandler} = $onlineRegistrationHandler;
        }
    }
    return $self->{_onlineUpdatable};
}


sub checkNoRestart {
    my ($self, $value) = @_;
    if ($value) {
        $self->setSkip('Password', 1);
        $self->setSkip('SystemUser', 1);
        $self->setSkip('SQLSysPasswd', 1);
    }
    return 1;
}

sub checkSQLSysPasswd{
    my ($self, $password) = @_;
    my $sql;
    my $rc = $self->SUPER::checkSQLSysPasswd ($password, undef, undef, \$sql);

    if (!$rc){
        return $rc;
    }

    if (defined $sql && $self->isOnlineUpdatable ()){
        my $onlineRegistrationHandler = $self->{_onlineRegistrationHandler};
        $onlineRegistrationHandler->setMsgLstContext([$self->getMsgLst()]);
        if($self->getValue('NoScriptServerRestart')){
            $onlineRegistrationHandler->setNoScriptServerRestart();
        }
        my $rc = $onlineRegistrationHandler->checkPreconditionOnline($sql);
        if (!defined $rc){
            $self->setErrorMessage("Cannot check database requirements for online unregistration", $onlineRegistrationHandler->getErrMsgLst());
            return undef;
        }
        if (!$rc){
            $self->getMsgLst()->addMessage("Online unregistration is not supported");
            $self->{_onlineUpdatable} = 0;
            delete $self->{_onlineRegistrationHandler};
            return 1;
        }
        $onlineRegistrationHandler->setMsgLstContext($self->getMsgLstContext());
        if(!$onlineRegistrationHandler->checkSqlUser()){
            return undef;
        }
        if ($onlineRegistrationHandler->isScriptServerRestartRequired()){
            $self->setSkip('NoScriptServerRestart', 0);
        }
    }
    return 1;
}




1;