#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc:
#

package SDB::Install::Gui::Dialogs::Finalize;

use Wx qw (
	wxNORMAL
    wxBOLD
    wxTE_MULTILINE
	wxTE_READONLY
    wxEXPAND
    wxVERTICAL
    wxTOP
    wxHORIZONTAL
    wxID_EXIT
    wxALL
	wxBOTTOM
    wxLI_VERTICAL
    wxALIGN_CENTER
    wxOK
    wxCENTRE
    wxICON_EXCLAMATION
    wxICON_INFORMATION
    );

use base SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::Globals;



sub new{
    my ($self ) = shift->SUPER::new(@_);

    #
    #   Sizer Stuff
    #
    
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $top_sizer->AddStretchSpacer(1);
    
    $self->{id} = 'finalize';
    $self->{name} = 'Finish';
    
    
    #
    #   Caption
    #
    
    $self->{'caption'} = Wx::StaticText->new($self,-1,"");
    $self->{'caption'}->SetFont( Wx::Font->new(14,wxNORMAL, wxNORMAL, wxBOLD, 0 )) if (!Wx::wxGTK1());
    $top_sizer->Add($self->{'caption'},0,wxALIGN_CENTER);
    
    #
    #   Text
    #
    
    $self->{'text'} = Wx::StaticText->new($self,-1,'');
    $self->{'text'}->SetFont ( Wx::Font->new(10,wxNORMAL, wxNORMAL, wxBOLD, 0 )) if (!Wx::wxGTK1());
    $top_sizer->Add($self->{'text'},0,wxALIGN_CENTER | wxTOP,20);
    
    
    #
    #   Pack&Go
    #
    
    $top_sizer->AddStretchSpacer(1);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    return $self;
}


sub init{
	my ($self,$config) = @_;
    $self->{'initialized'} = 1;

	if(defined $config->{'error_state'} && $config->{'error_state'} == 1){
		$self->{'caption'}->Show(1);
        $self->{'caption'}->SetLabel('An error occurred.');
        $self->{'text'}->SetLabel('For detailed information, please see the log file.');
	}
	else{
		$self->{'caption'}->Show(0);
			if (Wx::wxTheApp()->{kit}->IsDBStudioDistribution ()){
			    if ($config->{upgrade_skipped}){
                    $self->{'text'}->SetLabel("$gProductNameStudio is up-to-date.");
			    }
			    else{
				    $self->{'text'}->SetLabel("You have successfully installed the $gProductNameStudio.");
				}
			}
			elsif(Wx::wxTheApp()->{instconfig}->isa ('SDB::Install::Configuration::Upgrade')){
				my $sapsys = Wx::wxTheApp()->{sapSystem};
				if ($config->{upgrade_skipped}){
                    $self->{'text'}->SetLabel(sprintf ("$gProductNameEngine instance %s of system %s is up-to-date.", $sapsys->getNewDBInstanceNr(), $sapsys->{_sid}));
				}
				else{
				    $self->{'text'}->SetLabel(sprintf ('You have successfully updated the system %s with instance %s.',
					$sapsys->{_sid}, $sapsys->getNewDBInstanceNr()));
			    }
			    if (defined $config->{import_error} && $config->{import_error}){
			        my $warning =  Wx::StaticText->new($self,-1,'Problems occurred while importing delivery units (content).');
                    $warning->SetFont ( Wx::Font->new(10,wxNORMAL, wxNORMAL, wxBOLD, 0 )) if (!Wx::wxGTK1());
                    $self->GetSizer()->Insert(3 ,$warning,0,wxALIGN_CENTER | wxTOP,20);
                    $warning =  Wx::StaticText->new($self,-1,'To complete the content update, refer to SAP Note 1795885.');
                    $warning->SetFont ( Wx::Font->new(10,wxNORMAL, wxNORMAL, wxBOLD, 0 )) if (!Wx::wxGTK1());
                    $self->GetSizer()->Insert(4 ,$warning,0,wxALIGN_CENTER | wxTOP,5);
                    Wx::wxTheApp()->{return} = 2;
			    }
			}
			elsif(Wx::wxTheApp()->{instconfig}->isa ('SDB::Install::Configuration::NewDB')){
				my $sapsys = Wx::wxTheApp()->{sapSystem};
				$self->{'text'}->SetLabel(sprintf ('You have successfully installed the system %s with instance %s.', 
					$sapsys->{_sid}, Wx::wxTheApp()->{instconfig}->getValue ('InstanceNumber')));
			}
			else{
                if ($config->{upgrade_skipped}){
                    $self->{'text'}->SetLabel("The software is up-to-date.");
                }
                else{
                    $self->{'text'}->SetLabel('Installation finished successfully.');
                }
			}
		}
	return {'auto_next' => 1};
}

#-------------------------------------------------------------------------------
# If the Kit's eventhandler returns a defined ref to an array of strings, the entries are printed
# on stdout, on per line. These are the last lines to appear on stdout before the log file location 
# is indicated and stdout is closed.

sub ShowFinalMessage{
    my (
        $self,
        $app
    )= @_;
    if(defined $app && defined $app->{'installation'} && defined $app->{'installation'}->{'kit'}) {
        my $eventHandler = $app->{'installation'}->{'kit'}->getEventHandler();
        if(defined $eventHandler) {
            my $finalMessageArray = $eventHandler->getFinalMessage();
            if(defined $finalMessageArray) {
                $app->{'msglst'}->addMessages($finalMessageArray);
                my $finalMessage = join ("\n",@{$finalMessageArray});
                $app->ShowInfoMsg ($finalMessage);
            }
        }
    }
    return 1;
}

sub Process{
    my ($self,$config) = @_;
    $config->{updateInstallation} = undef;
    $config->{db} = undef;

    $self->GetWizard()->KillPreviousDialogs ();

    my $app = Wx::wxTheApp;
    if((not defined $config->{'error_state'}) ||  $config->{'error_state'} != 1) {
        $self->ShowFinalMessage($app);
    }
    $app->CleanUp ();
    #
    #   Add Log Viewer
    #
    $self->GetWizard->LogButton('&View Log',sub {
            my ($self,$evt) = @_;
            eval{
                require SDB::Install::LogViewer::Dialog::XLVDialog;
            };
            if ($@){
                Wx::MessageBox( "Error: $@", 'Log Viewer Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self ); 
                return undef; # Stay in current dialog!
            } else {
                my ($frame) = SDB::Install::LogViewer::Dialog::XLVDialog->new( $self, "$gProductName - XML Log Viewer", Wx::Point->new(300,100), Wx::Size->new(640,800) );
                $app->{with_timestamp} = 1;
                $frame->LoadMsgLstAfterShow ($app->getMsgLst());
                $frame->SetSize(640,800);
                $frame->SetMinSize([450,600]);
                $frame->ShowModal();
                $frame->Destroy();
                $frame = undef;
            }
      } );

    $self->GetWizard->{'cbutton'}->SetFocus;

    return {};
}


sub Destroy{
    my ($self) = @_;

    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }
	
    #
    #   Destroy elements
    #

    foreach my $element ('reboot_msg',
                        'logwin',
                        'staticline',
                        'text',
                        'caption',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}



sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
