
package SDB::Install::Gui::Dialogs::SelectStudioFeatures;

use Wx
	qw( wxHORIZONTAL wxALL wxALIGN_TOP wxCB_READONLY wxLC_REPORT wxLC_NO_HEADER wxNO_BORDER wxLIST_FORMAT_LEFT wxOK
	wxCENTRE wxICON_EXCLAMATION wxBLACK wxVERTICAL wxEXPAND wxTOP wxBOTTOM wxLEFT wxRIGHT wxDefaultPosition wxDefaultSize wxALIGN_LEFT wxALIGN_RIGHT );
use SDB::Install::Utils::DatabaseStudio::DatabaseStudioKnownFeatures qw (IsKnownFeatureKey GetKnownFeatureIdByKey GetDescription GetBatchKey GenerateFeatureDescriptionText);
use SDB::Install::Configuration::DatabaseStudio;
use SDB::Install::Gui::Design;
use Wx::Event qw (EVT_RADIOBUTTON EVT_COMBOBOX EVT_TEXT EVT_BUTTON);
use SDB::Install::Gui::Control::Button;
use SDB::Install::Globals qw ($gProductNameStudio);
use experimental qw (smartmatch);
use strict;

use base qw (SAPDB::Install::Wizard::Dialog::Base);

sub new {
	my ( $self ) = shift->SUPER::new ( @_ );
	my $is_gtk1          = Wx::wxGTK1 ();
	my $instconfig       = Wx::wxTheApp->{'instconfig'};
	my $kit              = Wx::wxTheApp->{'kit'};
	my $productname      = $instconfig->getProductName ();
	my $shortProductname = $instconfig->getShortProductName ();
	$self->{id}              = 'SelectStudioFeatures';
	$self->{name}            = "Select Features";
	$self->{label_text}      = "Select features to be installed";
	$self->{'allComponents'} = [];

	my $sizer = new Wx::BoxSizer ( wxVERTICAL );

	$self->{'upperLabel'} =
		new Wx::StaticText ( $self, -1, 'The following features will be updated',
		wxDefaultPosition, wxDefaultSize );
	$self->{'upperLabel'}->SetFont ( SDBFONT_DialogTitle ) if ( !$is_gtk1 );
	$sizer->Add ( $self->{'upperLabel'}, 0, wxLEFT | wxRIGHT | wxTOP, 20 );
	$sizer->AddSpacer ( 10 );
	#features to be updated list 
	$self->{'updatelist'} =
		new Wx::ListBox ( $self, -1, wxDefaultPosition, wxDefaultSize );
	$self->{'updatelist'}->SetFont ( SDBFONT_NormalText ) if ( !$is_gtk1 );
	$sizer->Add ( $self->{'updatelist'}, 1, wxEXPAND | wxLEFT | wxRIGHT, 20 );
	$sizer->AddSpacer ( 10 );
	
	#newfeatures list
	$self->{'lowerLabel'} =
		new Wx::StaticText ( $self, -1, 'Select features to be installed',
		wxDefaultPosition, wxDefaultSize );
	$self->{'lowerLabel'}->SetFont ( SDBFONT_DialogTitle ) if ( !$is_gtk1 );
	$sizer->Add ( $self->{'lowerLabel'}, 0, wxLEFT | wxRIGHT | wxTOP, 20 );
	$sizer->AddSpacer ( 10 );
	$self->{'installList'} =
		new Wx::CheckListBox ( $self, -1, wxDefaultPosition, wxDefaultSize );
	$self->{'installList'}->SetFont ( SDBFONT_NormalText ) if ( !$is_gtk1 );
	$sizer->Add ( $self->{'installList'}, 1, wxEXPAND | wxLEFT | wxRIGHT, 20 );
	$sizer->AddSpacer ( 10 );
	
    #Selection buttons
	$self->{'gridSizerBottom'} = new Wx::StdDialogButtonSizer ();
	$sizer->Add ( $self->{'gridSizerBottom'}, 0, wxALIGN_LEFT | wxBOTTOM, 10 );

	$self->{'selectAllBtn'} =
		new SDB::Install::Gui::Control::Button ( $self, -1, '&Select All',
		wxDefaultPosition, wxDefaultSize );
	EVT_BUTTON ( $self, $self->{'selectAllBtn'}, \&_onSelectAllBtn );
	$self->{'gridSizerBottom'}->Add ( $self->{'selectAllBtn'}, 0, wxLEFT, 20 );

	$self->{'deselectAllBtn'} =
		new SDB::Install::Gui::Control::Button ( $self, -1, '&Deselect All',
		wxDefaultPosition, wxDefaultSize );
	EVT_BUTTON ( $self, $self->{'deselectAllBtn'}, \&_onDeselectAllBtn );
	$self->{'gridSizerBottom'}->Add ( $self->{'deselectAllBtn'}, 0, wxLEFT, 5 );

	$self->SetSizer ( $sizer );
	$self->SetAutoLayout ( 1 );

	my $listener = sub {
		my ( $value, $instconfig ) = @_;
		if ( $instconfig->{params}->{'SelectedFeatures'}->{hidden} ) {
			$self->GetWizard ()->SkipDialog ( $self->GetID () );
		}
		return 1;
	};
	my $app = Wx::wxTheApp ();
	$app->{instconfig}->addParameterListener ( 'PATH', $listener );
	return $self;
}


sub _onSelectAllBtn {
	my ( $self, $event ) = @_;
	$self->_onBtn ( 1 );
}

sub _onDeselectAllBtn {
	my ( $self, $event ) = @_;
	$self->_onBtn ( 0 );
}

sub _onBtn {
	my ( $self, $isSelected ) = @_;
	for my $i ( 0 .. $#{ $self->{'allComponents'} } ) {
		my $component = $self->{'allComponents'}->[$i];
		$self->{'installList'}->Check ( $i, $isSelected );
	}
}

sub init {
	my ( $self, $config ) = @_;
	my $app = Wx::wxTheApp ();
	my  $instconfig = $app->{instconfig};
	@{$self->{'allComponents'}}=();
	my $isUpdate = $instconfig->isUpdate ();
	if ( $isUpdate ) {
		my $isOldFeatureSet = $instconfig->getFeatureManager()->isOldFeaturesSetInstalled();
		my $labelText =  $isOldFeatureSet ? 
				"$gProductNameStudio has been divided into features. Select which features you would like to install" :
				"The following features will be updated";
		$self->{'upperLabel'}->SetLabel($labelText);
		$self->{'lowerLabel'}->SetLabel("Select additional features to install");
		
		if($isOldFeatureSet){
			$self->{'updatelist'}->Hide();
			$self->{'lowerLabel'}->Hide();	
		}else{
			$self->{'updatelist'}->Show();
			$self->{'lowerLabel'}->Show();
			$self->_fillUpdateList();
		}
		$self->_fillInstallList ();
		
	}else{
		$self->{'upperLabel'}->SetLabel("Select features to install");
		$self->{'updatelist'}->Hide();
		$self->{'lowerLabel'}->Hide();
		$self->_fillInstallList ();
	}
	$self->Layout         ();
	return {};
}

sub _fillUpdateList {
	my ( $self ) = @_;
	$self->{'updatelist'}->Clear ();
	my $app = Wx::wxTheApp ();
	my $featureManager =  $app->{instconfig}->getFeatureManager();
	my $featuresForUpdate = $featureManager->getFeaturesForUpdate();
	for my $feature ( sort @$featuresForUpdate ) {
		$self->{'updatelist'}->Append ( GenerateFeatureDescriptionText($feature,1));
	}
}

sub _fillInstallList {
	my ( $self ) = @_;
	my $app = Wx::wxTheApp ();
	my  $instconfig = $app->{instconfig};
	my $featureManager =  $instconfig->getFeatureManager();

    $self->{'installList'}->Clear ();
	
	my $ui       = $instconfig->{params}->{'SelectedFeatures'}->{'ui_values'};
	my @uiValues = @$ui;
	my $valid = $instconfig->{params}->{'SelectedFeatures'}->{'valid_values'};
	my @validValues = @$valid;
	my %keyToUiMap;
	@keyToUiMap{@validValues} = @uiValues;

	my @selectedIds = @{ $featureManager->getSelectedFeaturesIds () };

	my $index = 0;
	for my $batchKey ( sort keys %keyToUiMap ) {
		if ( $batchKey eq 'all' || $batchKey eq 'none') {
			next;
		}
		my $featureId;
		if( IsKnownFeatureKey( $batchKey ) ){
				$featureId = GetKnownFeatureIdByKey ( $batchKey );
		} else {
			$featureId = $batchKey;
		}
		my $checked = $featureId ~~ @selectedIds;
		$self->{'installList'}->Append ( $keyToUiMap{$batchKey} );
		$self->{'installList'}->Check ( $index,  $checked );
		push @{$self->{'allComponents'}}, $batchKey;
		$index++;
	}
}

sub Process {
	# NEXT button was pressed on dialog
	my ( $self, $config ) = @_;

	my $instconfig = Wx::wxTheApp ()->{instconfig};

	my @selectedFeatureKeys;
	my $listedKeysRef = $self->{'allComponents'};
	for my $i ( 0 .. ( scalar @$listedKeysRef ) - 1 ) {
		if ( $self->{'installList'}->IsChecked ( $i ) ) {
			push @selectedFeatureKeys, $self->{'allComponents'}->[$i];
		}
	}

	my $value = join( ',', @selectedFeatureKeys );

	if ( !$instconfig->setValue ( 'SelectedFeatures', $value ) ) {
		Wx::MessageBox (
			$instconfig->GetErrorString (),
			"Configuration Error",
			wxOK | wxCENTRE | wxICON_EXCLAMATION, $self
		);
		$instconfig->ResetError ();
		return undef;
	}

	#hide default summary of this parameter
	#$instconfig->{params}->{'SelectedFeatures'}->{'hidden'} = 1;
	return {};
}

1;
