#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SDB::Install::Gui::Window::License;

use Wx qw ( wxVERTICAL wxHORIZONTAL wxALIGN_RIGHT
			wxEXPAND wxALL wxTOP wxRIGHT
			wxTE_MULTILINE wxTE_READONLY);

use Wx::Event qw (EVT_BUTTON EVT_COMMAND);

require Exporter;

our @EXPORT = qw (SDB_EVENT_TYPE_LICENSE_ACCEPT SDB_EVENT_TYPE_LICENSE_DECLINE
				  EVT_SDB_LICENSE_ACCEPT EVT_SDB_LICENSE_DECLINE);

our @ISA = qw (Wx::Panel Exporter);

sub new{
	my $self = shift->SUPER::new(@_);
	my $file = $_[4];
	my $top_sizer = Wx::BoxSizer->new (wxVERTICAL);
	
    my $license = '';
   
    if (-f $file){
			open (LC,$file);
			while (<LC>){
				$license .= $_;
			}
			close (LC);
    }
	
	$self->{txt} = Wx::TextCtrl->new($self,-1,$license,[-1,-1],
										[-1,-1],wxTE_MULTILINE |
										wxTE_READONLY);
    $top_sizer->Add ($self->{txt}, 1, wxEXPAND | wxALL,10);
    
    my $button_sizer = Wx::BoxSizer->new (wxHORIZONTAL);
	my $button_accept = Wx::Button->new ($self,-1,'&Accept',[-1,-1],[-1,-1]);
	my $button_decline = Wx::Button->new ($self,-1,'&Decline',[-1,-1],[-1,-1]);
	
	EVT_BUTTON ($self, $button_accept->GetId (), \&OnAccept);
	EVT_BUTTON ($self, $button_decline->GetId (), \&OnDecline);
	
	$button_sizer->Add ($button_decline,0,wxRIGHT,20);
	$button_sizer->Add ($button_accept,0);
	
	$top_sizer->Add ($button_sizer,0, wxALIGN_RIGHT | (wxALL) & (~wxTOP),10);
	$self->SetSizerAndFit ($top_sizer);
	$self->SetAutoLayout (1);
	return $self;
}


sub OnAccept{
	my ($self,$evt) = @_;
	$evt->SetId($self->GetId);
	$evt->SetEventType(SDB_EVENT_TYPE_LICENSE_ACCEPT ());
	$self->GetParent->AddPendingEvent($evt);
}


sub OnDecline{
	my ($self,$evt) = @_;
	$evt->SetId($self->GetId);
	$evt->SetEventType(SDB_EVENT_TYPE_LICENSE_DECLINE ());
	$self->GetParent->AddPendingEvent($evt);
}


sub SDB_EVENT_TYPE_LICENSE_ACCEPT {
	return 8759;
}

sub SDB_EVENT_TYPE_LICENSE_DECLINE {
	return 8758;
}

sub EVT_SDB_LICENSE_ACCEPT{
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_LICENSE_ACCEPT,$sub);
}

sub EVT_SDB_LICENSE_DECLINE{
	my ($handler,$id,$sub) = @_;
	EVT_COMMAND ($handler,$id,SDB_EVENT_TYPE_LICENSE_DECLINE,$sub);
}



sub Destroy{
	my ($self) = @_;
	
	my $sizer = $self->GetSizer ();
	if (defined $sizer){
		$sizer->Clear (1);
	}
	
	if (exists $self->{txt}){
		delete $self->{txt};
	}
	$self->SUPER::Destroy;

}

sub DESTROY{
	my ($self) = @_;
	print ">>>> DESTROY $self\n"
    if defined $SAPDB::Install::DEBUG::DESTRUCT &&
        $SAPDB::Install::DEBUG::DESTRUCT;
}
1;