package SDB::Install::HdbMountAPIInfo;

use base SDB::Install::PythonExecutor;
use SDB::Install::SysVars;
use SDB::Install::Tools qw (trim);

our $script = 'hdbmount.py';

#
# 1st arg is the directory containing the mount script 'hdbmount.py'.
# 2nd arg is the directory containing the ini file 'global.ini'.
sub new{
    my $self = shift->SUPER::new();
    $self->setScript ($_[0] . $path_separator . $script);
    $self->{ini}                     = $_[1];
    $self->{uid}                     = $_[2];
    $self->{gid}                     = $_[3];
    $self->{sudoersLine}             = undef;
    $self->{sudoersLinePrefix}       = undef;
    $self->{sudoersLineCommandArray} = undef;
    return $self;
}

sub getSudoersLinePrefix {
    my ($self)  = @_;
    if(not defined $self->{sudoersLinePrefix}) {
        my $retval = $self->fetchSudoersLine();
        if(not defined $retval) {
            return (undef, undef); # script output parsing failed
        }
        if($retval == 0) {
            return (0, undef); # script execution failed
        }
        $self->{sudoersLinePrefix} = $self->{sudoersLine};
        if(defined $self->{sudoersLinePrefix}) {
            $self->{sudoersLinePrefix} =~ s/(.*:).*/$1/;
        }
    }
    return (1, $self->{sudoersLinePrefix});
}

sub getSudoersLineCommandArray {
    my ($self)  = @_;
    if(not defined $self->{sudoersLineCommandArray}) {
        my $retval = $self->fetchSudoersLine();
        if(not defined $retval) {
            return (undef, undef); # script output parsing failed
        }
        if($retval == 0) {
            return (0, undef); # script execution failed
        }
        my $commandsString = $self->{sudoersLine};
        if(defined $commandsString) {
            $commandsString =~ s/.*:(.*)/$1/;
            trim(\$commandsString);
            $self->{sudoersLineCommandArray} = [];
            foreach $cmd (split (',' ,$commandsString)){
                trim (\$cmd);
                if(not $cmd eq '') {
                    push @{$self->{sudoersLineCommandArray}}, $cmd;
                }
            }
        }
    }
    return (1, $self->{sudoersLineCommandArray});
}

sub fetchSudoersLine {
    my ($self)  = @_;
    if(not defined $self->{sudoersLine}) {
        $self->{sudoersLinePrefix}       = undef;
        $self->{sudoersLineCommandArray} = undef;
        my $rc = $self->runScript ([
            "--sudoers", 
            "--configFiles=$self->{ini}",
            "--checkOwnership"
        ], $self->{uid}, $self->{gid});
        if(not $rc) {
            return 0;
        }
        my $outLines = $self->getStdOutLines();
        foreach my $line (@{$outLines}) {
            # take first non-(whitespace-only) line:
            if($line !~ /^\s*$/) {
                $self->{sudoersLine} = $line;
                last;
            }
        }
        if(not defined $self->{sudoersLine}) {
            return undef;
        }
        else {
            trim(\{$self->{sudoersLine}});
            if($self->{sudoersLine} !~ /.*:.*/) {
                # a valid sudoers line has at least one colon:
                $self->{sudoersLine} = undef;
                return undef;
            }
        }
    }
    return 1;
}


1;
