package SDB::Install::Installation::DatabaseStudio;

use SDB::Install::Installation;
use SDB::Install::SysVars;
use SDB::Install::System qw (deltree
                             makedir
                             isAdmin
                             isRootFs
                             removeUninstallEntry);
use SAPDB::Install::Hostname;
use SDB::Install::Globals qw ($gProductName $gProductNameStudio);

use strict;

our @ISA = qw (SDB::Install::Installation);

our $regFileName = 'installations.dbstudio';


our $installations;

#----------------------------------------------------------------------------

sub new{
    my $self = shift->SUPER::new (@_);
    $self->init ();
    return $self;
}

sub EnumDBStudioInstallations{
    my ($msglst, $nocache) = @_;
    if (defined $installations && !$nocache){
        return $installations;
    }
    my $obj = new __PACKAGE__;
    $installations = $obj->EnumInstallations ();
    return $installations;
}

sub init{
    my ($self) = @_;
    $self->SUPER::init ();
    if (defined $self->{path}){
        $self->{'registrypath'} = $self->{'path'}. $path_separator . 'install';
    }
}

sub isUserMode{
    return !isAdmin();
}

sub asString{
	my ($self) = @_;
	return "$gProductNameStudio " . $self->GetVersion () . ' ' . $self->{path};
}

sub initNewInstallation{
	my ($self) = @_;
	if (defined $self->{copy_repository}){
		return 1;
	}
    my $dirMode = ($isApple || $>) ? 0775 : 0555;
	if (!-d $self->{path}){
		my $cfg = {'mode' => $dirMode};
		if (!defined makedir ($self->{path}, $cfg)){
			$self->AddError ("Cannot create program directory", $cfg);
			return undef;
		}
	}
	if (!-d $self->{registrypath}){
		my $cfg = {'mode' => $dirMode};
		if (!defined makedir ($self->{registrypath}, $cfg)){
			$self->AddError ("Cannot create install registry directory", $cfg);
			return undef;
		}
	}
	return 1;
}

sub getUID{}

sub getGID{}

#----------------------------------------------------------------------------

sub getProductName {
    return $gProductNameStudio;
}

#----------------------------------------------------------------------------

sub getProgramPath{
	return $_[0]->{path};
}

sub getDataPath;
*getDataPath = \&getProgramPath;

sub getRegFileName{
    return $regFileName;
}

sub Uninstall{
	my ($self, $keep_workspace) = @_;
	if (!defined $keep_workspace){
		$keep_workspace = 0;
	}
	
	my $exe = $self->{path} . $path_separator .
			($isWin ? 'hdbstudio.exe' : 'hdbstudio');

	my $rc = $self->SUPER::Uninstall();
	if (defined $rc){
		my $path = $self->{path};
		if (-d $path && !isRootFs ($path)){
			my $errlst = new SDB::Install::MsgLst ();
			if (!defined deltree ($path, $errlst)){
				$self->AddError ("Cannot remove directory '$path'", $errlst);
				$rc = undef;
			}
		}
	}

    my $msglst = new SDB::Install::MsgLst ();
	if (!$self->isUserMode()){
		if (!defined removeUninstallEntry ('HDBSTUDIO', 1, $self->{path}, $msglst)){
			$self->AddError ('Cannot remove uninstall entry', $msglst);
		}
	}

	return $rc;
}

sub is64bit {
	my ($self) = @_;
	if ($isApple){
		return 1;
	}
	my $dbstudio_exe = $self->{'path'} . $path_separator . 'hdbstudio' . ($isWin ? '.exe' : '');
	if (! -f $dbstudio_exe){
		return undef;
	}
	require SAPDB::Install::BuildInfo;
	my $magic = SAPDB::Install::BuildInfo::GetMagicString ($dbstudio_exe);
	if (!$magic){
		return undef;
	}
	return ($magic =~ /AMD64|X86-64/);
}


1;
