package SDB::Install::Kit::OfficeClient;
use SDB::Install::System qw (createUninstallEntry);
use SDB::Install::SysVars;
use SDB::Install::Globals qw ($gProductNameOfficeClient);

use strict;

our @ISA = qw (SDB::Install::Kit);


sub Install{
    my $self = shift;
    if (!defined $self->SUPER::Install(@_)){
        return undef;
    }
    my $hdbuninst = join ($path_separator, $self->{installation}->{path}, 'install', 'hdbuninst.exe');
    if (-f $hdbuninst){
        my $errlst = new SDB::Install::MsgLst ();
        my %entry = (
            'name' => $gProductNameOfficeClient .  ($self->is64bit () ? ' 64bit' : ' 32bit'),
            'cmd' => $hdbuninst,
            'size' => ($self->GetSize () / 1024),
            'version' => $self->GetVersion ()
        );
        if (!defined createUninstallEntry ('HDBOFFICECLIENT', \%entry, 1, $self->{installation}->{path}, $errlst)){
            $self->AddError ("Cannot add uninstall entry", $errlst);
            return undef;
        }
    }
    return 1;
}

1;
