package SDB::Install::LSS::Installer;
use strict;
use warnings;

use parent qw(SDB::Install::Installer);
use SDB::Install::LSS::LssInstance;
use SDB::Common::BuiltIn;
use File::Basename qw(fileparse);
use File::Spec;


sub getSid {
    my $self = shift;
    my $installation = $self->getInstallation();
    my $lssInstDir = $installation->getProgramPath();
    my ( $sid, $lssSharedPath, $suffix) = fileparse($lssInstDir);
    if( $sid !~ /$SDB::Install::Installer::sid_pattern/){
        $self->getErrMsgLst()->addError("Wrong installation path $lssInstDir. $sid is not valid");
        return undef;
    }
    return $sid;
}

sub getSharedDir {
    my $self = shift;
    my $installation = $self->getInstallation();
    my $lssInstDir = $installation->getProgramPath();
    my ($sid, $lssSharedPath, $suffix) = fileparse($lssInstDir);
    return File::Spec->catdir($lssSharedPath);
}

sub getLssInstance {
    my $self = shift;
    my($sharedDir,$sid) =($self->getSharedDir(),$self->getSid());
    return undef if(!$sharedDir || !$sid);
    return SDB::Install::LSS::LssInstance->new(undef, $sid, $sharedDir);
}

sub renameSharedDir {
    my ($self, $newSid) = @_;
    my $currentSid = $self->getSid();
    my $oldPath = File::Spec->catfile($self->getSharedDir(), $currentSid);
    my $newPath = File::Spec->catfile($self->getSharedDir(), $newSid);

    $self->getMsgLst()->addMessage("Renaming '$oldPath' to '$newPath'");
    $self->renameHanaSID($currentSid, $newSid, $self->getSharedDir());
    my $builtin = SDB::Common::BuiltIn->get_instance();
    if (!$builtin->rename($oldPath, $newPath)) {
        $self->getErrMsgLst()->addError("Cannot rename '$oldPath' to '$newPath': $!");
        return undef;
    }
    $self->init();
    return 1;
}

1;
