package SDB::Install::LSS::LssConfigExecutor;

use SDB::Common::Utils qw(getSidcryptName);
use SDB::Install::Globals qw($gShortProductNameLSS $gKeynameLSS);
use SDB::Install::RemoteHostctrlHosts;
use SDB::Install::System qw(isAdmin);
use SAPDB::Install::Hostname;
use SDB::Install::LSS::Tools::LSSConfig;
use SDB::Install::User;
use strict;
use parent qw(SDB::Install::Base);

sub new {
    my ($class, $configuration, $component) = @_;
    my $self = {};
    $self->{_config} = $configuration;
    $self->{_component} = $component;
    bless $self, $class;
    return $self;
}

sub getProgressMessage {
    ...
}

sub setConfiguration {
    my ($self, $config) = @_;
    $self->{_config} = $config;
}

sub getConfiguration {
    my ($self) = @_;
    return $self->{_config};
}

sub setComponent {
    my ($self, $component) = @_;
    $self->{_component} = $component;
}

sub getComponent {
    my ($self) = @_;
    return $self->{_component};
}

sub getLssCfg {
    my ($self) = @_;
    my $config = $self->getConfiguration();
    my $sidcrypt = getSidcryptName($config->getValue('SID'));
    my $user = SDB::Install::User->new($sidcrypt);

    my $lssCfg = SDB::Install::LSS::Tools::LSSConfig->new($config->getValue('SID'), $user->id(), $user->gid());
    $lssCfg->setMsgLstContext($self->getMsgLstContext());
    return $lssCfg;
}

sub _executeSHAOperation {
    my ($self) = @_;

    my $rc = 1;
    my $hostname = hostname();
    my $localExecution = new SDB::Install::RemoteHostctrlHosts(($hostname));

    my $message = $self->getMsgLst()->addProgressMessage($self->getProgressMessage().'...');
    my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);

    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    $localExecution->setOutputHandler ($hostname, $progressHandler);
    $localExecution->setMsgLstContext($self->getMsgLstContext());

    my $optionMap = $self->_buildSHAOptionsMap();
    my $progressMessage = "Calling $gShortProductNameLSS config tool";
    my $localExecutionReturnCode = $localExecution->executeHostctrlParallel($self->getSHAOperation(),
                                                        $self->getConfiguration(), # instconfig
                                                        undef, # param IDs
                                                        undef, # password IDs
                                                        undef, # remote ignore
                                                        undef, # remote timeout
                                                        $progressMessage, # progress_message,
                                                        undef, # done_message,
                                                        $progressMessage." through SAP Host Agent Operation failed.", # error_message,
                                                        $optionMap,
                                                        undef, # host option map
                                                        undef, # only on hosts
                                                        undef, # do not fail
                                                        1, # Suppress Console msgs
                                                        );
    if (!defined($localExecutionReturnCode) || ($localExecutionReturnCode != 0)) {
        $rc = undef;
    }
    $message->endMessage(undef, $self->getProgressMessage());
    $self->setMsgLstContext($saveContext);
    return $rc;
}

sub execute {
    ...
}

sub getSHAOperation {
    ...
}

sub _buildSHAOptionsMap {
    ...
}

sub _getArgs {
   ...
}

1;