package SDB::Install::LSS::Registrator::ComponentRegistratorFactory;
use strict;
use warnings;

use SDB::Install::System qw(isAdmin);
use SDB::Install::LSS::Registrator::ComponentRegistratorRoot;
use SDB::Install::LSS::Registrator::ComponentRegistratorSidadm;

sub getInstance{
    my ($self, $configuration, $component) = @_;
    my $class;
    if(isAdmin()){
        $class = SDB::Install::LSS::Registrator::ComponentRegistratorRoot->new($configuration, $component);
    }else {
        $class = SDB::Install::LSS::Registrator::ComponentRegistratorSidadm->new($configuration, $component);
    }
    return $class;
}

1;