package SDB::Install::LSS::Registrator::ComponentRegistratorRoot;
use strict;
use warnings;

use File::Spec;
use File::stat;
use SDB::Install::Manifest;

use parent qw(SDB::Install::LSS::Registrator::ComponentRegistratorBase);

sub execute{
    my ($self) = @_;
    my $lssCfg = $self->getLssCfg();
    my $args = $self->_getArgs();
    if (!defined $args) {
        return undef;
    }
    if (!$lssCfg->importComponentHashes(@$args)) {
        return undef;
    }
    return 1;
}

sub _getArgs {
    my ($self) = @_;
    my $tmpDir = $self->{_tmpDir} = $self->_createTmpDir(); # makes sure File::Temp obj stays in scope
    return undef if (!defined $tmpDir);
    my $tmpManifest = SDB::Install::Manifest->new(File::Spec->catfile($tmpDir, 'manifest'));
    my $tmpSignaturePath = File::Spec->catfile($tmpDir, 'SIGNATURE.SMF');
    return [$tmpManifest, File::stat::stat($tmpSignaturePath) ? $tmpSignaturePath : undef, $self->getProgressMessage()];
}

1;