package SDB::Install::LSS::Registrator::ComponentRegistratorSidadm;

use strict;
use warnings;
use parent qw(SDB::Install::LSS::Registrator::ComponentRegistratorBase);

use File::Spec;
use File::stat;

sub execute{
    my ($self) = @_;
    return $self->_executeSHAOperation();
}

sub _buildSHAOptionsMap {
    my ($self) = @_;
    my $config = $self->getConfiguration();
    my $tmpDir = $self->{_tmpDir} = $self->_createTmpDir(); # makes sure File::Temp obj stays in scope
    return {} if (!defined $tmpDir);
    my $tmpDirPath = $tmpDir->dirname();

    my $tmpSignaturePath = File::Spec->catfile($tmpDirPath, 'SIGNATURE.SMF');
    return {
        'COMPONENT_MANIFEST_DIR' => $tmpDirPath,
        'COMPONENT_SIGNATURE' => File::stat::stat($tmpSignaturePath) ? $tmpSignaturePath : undef,
        'SID' => $config->getValue('SID'),
    };
}

sub getSHAOperation{
    return 'CollectComponentHashes_v3';
}

1;