package SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierRoot;
use strict;
use warnings;

use parent qw(SDB::Install::LSS::TrustLevelModifier::TrustLevelModifierBase);

sub execute{
    my ($self) = @_;
    my $lssCfg = $self->getLssCfg();
    my $args = $self->_getArgs();
    if (!$lssCfg->trustComponent(@$args)) {
        return undef;
    }
    return 1;
}

sub _getArgs {
    my ($self) = @_;
    my $component = $self->getComponent();
    my $manifest = $component->getManifest();
    my $trustLevel = $self->getTrustLevel();
    return [$manifest, $trustLevel, $self->getProgressMessage()];
}

1;