#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Abstract filter class for every filter.

package SDB::Install::LogViewer::Filter::AbstractFilter;

##
# Boring Constructor.
##

sub new () {
    my $invocant = shift;
    my $class = ref ($invocant) || $invocant;
    
    my $self = {
    };
    
    return bless ($self, $class);
}

##
# Start filter method. Starts the traverse
# method SeekAndDestroy.
# 
# @param
#   CacheTree cachetree - Cache Tree
##

sub Filter() {
    my ($self, $cachetree) = @_;
    
    return unless $cachetree;

    my $nodeCache = $cachetree->GetNodeCache();
    #attantion: unsorted!
	my $id;
    foreach $id (0 .. (@$nodeCache - 1)) {
        $self->SeekAndDestroy( $nodeCache->[$id], $cachetree );
    }
    
    1;    
}

##
#  This method call the CheckAndKill method. This
#  method must be implement by children classes.
# 
# @param
#   TreeElement node - current item id
#   CacheTree cacheTree - Cache Tree
##

sub SeekAndDestroy () {
    my ($self, $node, $cacheTree) = @_;

    # Check filter
    my $data = $cacheTree->GetPlData( $node );
    
    # reaction depends on filter attribute
    if (defined $data) {
        if ($data->{filter} eq 'Require') {
            $self->CheckAndKill($node, $cacheTree);
        }
    }
    
    1;
}


##
# Set filter ID.
# 
# @param
#   scalar ID - ID
##

sub SetID() {
    my ($self, $ID) = @_;
    $self->{ID} = $ID;
    1;
}


##
# Get filter ID.
# 
# @return
#   scalar ID
##

sub GetID() {
    my ($self) = @_;
    return $self->{ID};
}


##
# Set filter enable.
# 
# @param
#   scalar bool - enable or disable filter
##

sub SetEnable() {
    my ($self, $bool) = @_;
    $self->{ENABLE} = $bool;
    1;
}


##
# Get filter enable state.
# 
# @return
#   filter enable or disable state
##

sub IsEnable() {
    my ($self) = @_;
    return $self->{ENABLE};
}

sub DESTROY {
	my ($self) = @_;
	$self->SUPER::DESTROY if $self->can("SUPER::DESTROY");
}

1;
