#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Dialog for time filter. 

package SDB::Install::LogViewer::Filter::TimeDialog;

use strict;

use vars qw(@ISA);
@ISA=qw(Wx::Dialog);

use Wx qw(
        wxDEFAULT_DIALOG_STYLE
        wxLI_HORIZONTAL
        wxHORIZONTAL
        wxALIGN_CENTER_HORIZONTAL 
        wxGREEN
        wxRED
        wxCB_READONLY
        wxEXPAND
        wxALL
        );

use Wx::Event qw(
       EVT_BUTTON
       EVT_TEXT
       );


use SDB::Install::LogViewer::Filter::TimeFilter;


##
# Constructor for dialog initialisation.
#
# @param
#   scalar        - titel
#   Wx::Point     - Position
#   Wx::Size      - size
#   CacheTree     - content tree
#   FilterHandler - filter handler
##

sub new {
    my( $class ) = shift;
    my( $self ) = $class->SUPER::new( undef, -1, $_[0], $_[1], $_[2], wxDEFAULT_DIALOG_STYLE );
    $self->{CACHE} = $_[3];
    $self->{FILTERHANDLER} = $_[4];
    
    my $masterSizer = Wx::FlexGridSizer->new(3,1,5,5);
    
    #
    #   Content
    #
    my $contentsizer = Wx::FlexGridSizer->new(5,2,10,10);
    
    my @ReqExk = ("Require","Exclude");
    $self->{'filter_label'} = Wx::StaticText->new ($self, -1, 'Filter:');
    $self->{'filter_reqexc_combo'} = Wx::ComboBox->new ($self, -1,$ReqExk[0], [-1,-1],[-1,-1],\@ReqExk, wxCB_READONLY);
    
    #get in right order with sort
    my @_timelist = sort $self->{CACHE}->GetDifferentAttributeValuesByName('_TIME');
    
    $self->{'filter_min_label1'} = Wx::StaticText->new ($self, -1, 'Min _TIME:');
    $self->{'filter_min_label2'} = Wx::StaticText->new ($self, -1, $_timelist[0].'  ' || '');
    $self->{'filter_max_label1'} = Wx::StaticText->new ($self, -1, 'Max _TIME:');
    $self->{'filter_max_label2'} = Wx::StaticText->new ($self, -1, $_timelist[$#_timelist].'  ' || '');
    
    $self->{'filter_min_label3'} = Wx::StaticText->new ($self, -1, 'Set min _TIME:');
    $self->{'filter_min_textctrl'} = Wx::TextCtrl->new ($self, -1, $_timelist[0] || '');
    $self->{'filter_max_label3'} = Wx::StaticText->new ($self, -1, 'Set max _TIME:');
    $self->{'filter_max_textctrl'} = Wx::TextCtrl->new ($self, -1, $_timelist[$#_timelist] || '');
    
    $contentsizer->Add ($self->{'filter_label'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_reqexc_combo'},1,wxEXPAND);
    
    $contentsizer->Add ($self->{'filter_min_label1'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_min_label2'},1,wxEXPAND);
    $contentsizer->Add ($self->{'filter_max_label1'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_max_label2'},1, wxEXPAND);
    
    $contentsizer->Add ($self->{'filter_min_label3'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_min_textctrl'},1,wxEXPAND);
    $contentsizer->Add ($self->{'filter_max_label3'},1, wxEXPAND);
    $contentsizer->Add ($self->{'filter_max_textctrl'},1, wxEXPAND);

    $contentsizer->AddGrowableRow( 0 );
    $contentsizer->AddGrowableCol( 1 );
        
    $masterSizer->Add ($contentsizer, 1, wxEXPAND | wxALL , 10);
    
    #
    #   Horizontal Line
    #
    
    $self->{'masterline'} = Wx::StaticLine->new( $self, -1, [-1,-1], [-1,2], wxLI_HORIZONTAL);
    $masterSizer->Add ($self->{'masterline'}, 1, wxEXPAND ,);
    
    #
    #   Buttons
    #
    
    my $buttonsizer = Wx::FlexGridSizer->new(1,2,10,10);
    $self->{'cancel_button'} = Wx::Button->new ($self, -1, 'Cancel');
    $self->{'set_button'} = Wx::Button->new ($self, -1, 'Set');
    $self->{'set_button'}->Enable(0) if (scalar @_timelist eq 0);
    
    $buttonsizer->Add ($self->{'cancel_button'},1, wxALIGN_CENTER_HORIZONTAL );
    $buttonsizer->Add ($self->{'set_button'},1, wxALIGN_CENTER_HORIZONTAL );
    $masterSizer->Add ($buttonsizer, 1, wxALL | wxALIGN_CENTER_HORIZONTAL, 10);

    #---------Events-------------
    
    #TextChange
    EVT_TEXT ($self,$self->{'filter_min_textctrl'}->GetId,sub {
        $self->CheckTextCtrl ($self->{'filter_min_textctrl'});
   
    } );
    
    EVT_TEXT ($self,$self->{'filter_max_textctrl'}->GetId,sub {
         $self->CheckTextCtrl ($self->{'filter_max_textctrl'});
    } );
    
    #Cancel-Button
    EVT_BUTTON( $self, $self->{'cancel_button'}->GetId, \&OnClose );
    
    #Set Filter Button
    EVT_BUTTON( $self, $self->{'set_button'}->GetId, sub {
        my ($self,$evt) = @_;
        $self->{FILTERHANDLER}->AddFilter (
            SDB::Install::LogViewer::Filter::TimeFilter->new(
                                                            $self->{'filter_reqexc_combo'}->GetValue(),
                                                            $self->{'filter_min_textctrl'}->GetValue(),
                                                            $self->{'filter_max_textctrl'}->GetValue()
                                                            ));
        $self->Destroy();
      } );

    #---------Other stuff-------------

    $self->SetSizerAndFit($masterSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    
    $self->CheckTextCtrl ($self->{'filter_min_textctrl'});
    $self->CheckTextCtrl ($self->{'filter_max_textctrl'});
    
    $self;
}


##
# Check TextCtrl content to validate date text.
# Change the background colour.
# 
# @param
#   Wx::TextCtrl textctrl - TextCtrl to check
##

sub CheckTextCtrl () {
	my ($self, $textctrl) = @_;
	if ($textctrl->GetValue() =~ m/^\d{4}-\d\d-\d\d \d\d:\d\d:\d\d.\d\d\d$/o) {
        $textctrl->SetBackgroundColour (wxGREEN);
        $textctrl->Refresh(1);
	} else {
	    $textctrl->SetBackgroundColour (wxRED);
	    $textctrl->Refresh(1);
	}
	1;    
}


##
# Boring close method.
##

sub OnClose {
  my( $this, $event ) = @_;
  
  $this->Destroy();
}


##
# Destroyer method.
##

sub Destroy{
	my ($self) = @_;
	
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
       $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
    foreach my $element (
                        'filter_min_label1',
                        'filter_min_label2',
                        'filter_max_label1',
                        'filter_max_label2',
                        'filter_min_label3',
                        'filter_min_textctrl',
                        'filter_max_label3',
                        'filter_max_textctrl',
                        'set_button', 
                        'cancel_button',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

1;