#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Time filter class to filtering for _TIME attributes.

package SDB::Install::LogViewer::Filter::TimeFilter;

use strict;

use vars qw(@ISA);

use SDB::Install::LogViewer::Filter::AbstractFilter;

our @ISA = qw (SDB::Install::LogViewer::Filter::AbstractFilter);

my $CAT = '_TIME'; # this attribute is program


##
# Constructor for initialization.
##

sub new{
	my($self ) = shift->SUPER::new();
	
	$self->{RequireOrExclude} = shift;
    $self->{TimeMin} = shift;   
    $self->{TimeMax} = shift;
    
	return $self;
}


##
# This method checks the current tree item
# for destroying. This method knows no pain.
#
# @param
#   TreeElement item - item to check
#   CacheTree xlvtree - CacheTree
##

sub CheckAndKill () {
   my ($self, $item, $cacheTree) = @_;
   if ( defined $item){
        my $data = $cacheTree->GetPlData($item);
        if ($self->{RequireOrExclude} eq 'Require') {
            if (defined $data->{$CAT}) {
                # must be in min-max
                my @tmplist = sort ($self->{TimeMin}, $data->{$CAT} , $self->{TimeMax});
                if ($data->{$CAT} ne $tmplist[1] ) {
                    $data->{filter} = 'Exclude';
                }
            } else {
                $data->{filter} = 'Exclude';
            }
        } elsif($self->{RequireOrExclude} eq 'Exclude') {
           if (defined $data->{$CAT}) {
                # must be out min-max
                my @tmplist = sort ($self->{TimeMin}, $data->{$CAT} , $self->{TimeMax});
                if ($data->{$CAT} eq $tmplist[1] ) {
                    $data->{filter} = 'Exclude';
                } 
            } 
        }
        $cacheTree->SetPlData($item, $data);
    }
    1;
}


##
# Get the category.
#
# @return
#   scalar category
##

sub GetCatergory(){
    my ($self)=@_;
    return $CAT; 
}


##
# Get a beautiful string with attribute name and require state.
#
# @return
#   scalar string
##

sub ToString(){
    my ($self)=@_;
    return "From ".$self->{TimeMin}." to ".$self->{TimeMax}." #".$self->{RequireOrExclude}; 
}

1;