#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Save Element.

package SDB::Install::LogViewer::Type::TreeElement;
use strict;


sub new () {
    my $invocant = shift;
    my $class = ref ($invocant) || $invocant;
    my $self = {
        parent => shift,
        text => shift,
        data => shift,
        id => shift,
        children => [],
    };
    return bless ($self, $class);
}

sub AddChild {
    my ($self, $treeElement) = @_;
    push @{$self->{children}}, ($treeElement);
    1;
}

sub GetChildCount {
    my ($self) = @_;
    return scalar (@{$self->{children}});
}

sub HasChildren {
    my ($self) = @_;
    return @{$self->{children}} ? 1 : 0;
}

sub GetParent {
    my ($self) = @_;
    return $self->{parent};
}

sub GetId () {
    my ($self) = @_;
    return $self->{id};
}

sub SetText {
    my ( $self, $text ) = @_;
    $self->{text} = $text;
}

sub GetText {
    my ( $self ) = @_;
    return $self->{text};
}

sub GetData {
    my ( $self ) = @_;
    return $self->{data};
}

sub GetDataWithId {
    my ( $self ) = @_;
	print ">>> SCHNIFFI\n";

    my %hash;
	my ($key,$value);
    while (($key,$value) = each %{$self->{data}}) {
        $hash{$key} = $value;
    }
    $hash{id} = $self->{id};
    return \%hash;
}

sub SetData {
    my ( $self, $data ) = @_;
    $self->{data} = $data;
}

sub GetChildByNr {
    my ( $self,$nr ) = @_;
    if ((scalar (@{$self->{children}})) >= $nr) {
        #get first child
        return $self->{children}->[$nr];        
    } else {
        return undef;
    }
}

sub NrOfChild {
    my ( $self, $node ) = @_;
    my $id = $node->GetId();
    my $count = 0;
    foreach my $child (@{$self->{children}}) {
        if ($child->GetId() == $id) {
            return $count;
        }
        $count++;
    }
    return -1;
}

sub GetLastChild {
    if (@{$_[0]->{children}}){
		return $_[0]->{children}->[$#{$_[0]->{children}}];
	}
    return undef;
}

1;