#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Window for Log Viewer

package SDB::Install::LogViewer::Window::XLVWindow;

use SDB::Install::SysVars qw ($isWin);
use vars qw(@ISA);
use strict;

@ISA=qw(Wx::Panel);

use Wx qw( 
           wxHORIZONTAL
           wxTE_MULTILINE
           wxLC_SINGLE_SEL
           wxLEFT
           wxTOP
           wxLIST_AUTOSIZE
           wxWHITE
           wxVERTICAL
           wxTE_PROCESS_ENTER
           wxRED
           wxTE_NOHIDESEL
           wxTE_RICH2
           wxLI_HORIZONTAL
           wxTheClipboard
           wxEXPAND
           wxLIST_NEXT_ALL
           wxLIST_STATE_SELECTED
           wxLIST_STATE_FOCUSED
           wxMAXIMIZE_BOX
           wxMINIMIZE_BOX
           wxLC_REPORT
           wxLC_NO_HEADER
           wxTE_READONLY
           wxHSCROLL
           wxLC_VIRTUAL
           wxALL
           wxLC_LIST
           wxALIGN_CENTER_VERTICAL
           wxCB_READONLY
           wxRESIZE_BORDER
           wxDEFAULT_DIALOG_STYLE
           wxACCEL_CTRL
           wxNORMAL
           wxTELETYPE
         );

use Wx::Event qw(
       EVT_BUTTON
       EVT_TREE_SEL_CHANGED
       EVT_TREE_ITEM_EXPANDING
       EVT_COMBOBOX
       EVT_LIST_ITEM_SELECTED
       EVT_TEXT
       EVT_TEXT_ENTER
       EVT_LIST_ITEM_SELECTED
       EVT_LIST_ITEM_DESELECTED
       EVT_TREE_ITEM_RIGHT_CLICK
       EVT_CHECKBOX
       EVT_MENU
       EVT_NOTEBOOK_PAGE_CHANGED
       EVT_INIT_DIALOG
       EVT_LIST_ITEM_RIGHT_CLICK
       );

use SDB::Install::LogViewer::Control::XLVTreeCtrl;
use SDB::Install::LogViewer::Control::XLVListCtrl;
use SDB::Install::LogViewer::Control::XLVTreeDetailsCtrl;
use SDB::Install::LogViewer::Filter::FilterHandler;
use SDB::Install::LogViewer::Type::Cache;
use SDB::Install::LogViewer::Search::Find;

my @notebooklist = ('Simple View', 'Expert View');

#my $lasttimestop = time;


 our $ID_COPY = 12102;
 our $ID_SELECT_ALL = 12103;

sub new {
    my( $class ) = shift;
    my ($self) = $class->SUPER::new( $_[0], -1 );
    $self->Show(0);
    
    #------Filter----------
    
    $self->{FILTERHANDLER} = SDB::Install::LogViewer::Filter::FilterHandler->new ();
    
    #------Find------------
    
    $self->{FIND} = SDB::Install::LogViewer::Search::Find->new ();
    
    #------Cache-----------
    
    $self->{CACHE} = SDB::Install::LogViewer::Type::Cache->new ();
    
    #---------UI-----------

    #
    #   Tab
    #
    
    $self->{'masterNotebook'} = Wx::Notebook->new($self,-1, );
    my $nbsizer = Wx::NotebookSizer->new( $self->{'masterNotebook'} );
    
    #
    #   Simple View -Tab
    #
    
    $self->{'simple_page'} = Wx::Panel->new($self->{'masterNotebook'},-1,);
    $self->{'masterNotebook'}->AddPage($self->{'simple_page'},$notebooklist[0], 1);
    my $simplelog_Sizer = Wx::FlexGridSizer->new(2,1,5,5);    
    
        #
        #   Simple TextView
        #
        $self->{'simple_textctrl'} = SDB::Install::LogViewer::Control::XLVListCtrl->new($self->{'simple_page'}, -1,[-1,-1],[-1,-1],wxLC_REPORT| wxLC_VIRTUAL | wxLC_NO_HEADER  );
        $simplelog_Sizer->Add ($self->{'simple_textctrl'}, 1, wxEXPAND);
        $self->{'simple_textctrl'}->SetFont(Wx::Font->new(10, wxTELETYPE, wxNORMAL, wxNORMAL));
        
        #
        #   Search Box
        #
        $self->{'simplesearch_StaticBox'} = Wx::StaticBox->new ($self->{'simple_page'},-1,'Text Search',);
        my $simplesearchSizer = Wx::StaticBoxSizer->new($self->{'simplesearch_StaticBox'},wxHORIZONTAL);
        $self->{'simplesearch_label'} = Wx::StaticText->new ($self->{'simple_page'}, -1, 'Find:');
        $self->{'simplesearch_textctrl'} = Wx::TextCtrl->new ($self->{'simple_page'}, -1,'',[-1,-1],[-1,-1],wxTE_PROCESS_ENTER );
        $self->{'simplesearch_next_button'} = Wx::Button->new ($self->{'simple_page'}, -1, 'Next');
        $self->{'simplesearch_previous_button'} = Wx::Button->new ($self->{'simple_page'}, -1, 'Previous');
        $self->{'simplesearch_matchcase_checkbox'} = Wx::CheckBox->new ($self->{'simple_page'}, -1, 'Match Case');
        $simplesearchSizer->Add ($self->{'simplesearch_label'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $simplesearchSizer->Add ($self->{'simplesearch_textctrl'},1, wxEXPAND | wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $simplesearchSizer->Add ($self->{'simplesearch_matchcase_checkbox'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $simplesearchSizer->Add ($self->{'simplesearch_next_button'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $simplesearchSizer->Add ($self->{'simplesearch_previous_button'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $simplelog_Sizer->Add ($simplesearchSizer, 1, wxEXPAND);
        
    $simplelog_Sizer->AddGrowableRow( 0 );
    $simplelog_Sizer->AddGrowableCol( 0 );
    $self->{'simple_page'}->SetSizer($simplelog_Sizer);
    
    $self->{menu} = Wx::Menu->new();
    $self->{menu}->Append($ID_SELECT_ALL, 'Select All' );
    $self->{menu}->Append($ID_COPY, 'Copy' );

    EVT_MENU($self, $ID_COPY, sub {
                                                my ($self, $evt) = @_;
                                                return if ($self->{'simple_textctrl'}->GetSelectedItemCount () < 1);
                                                my $list = $self->GetSelectedSimpleListItems ();
                                                my $text = join ($isWin ? "\r\n" : "\n", @$list);
                                                ToClipBoard ($text);
                                            });
    EVT_MENU($self, $ID_SELECT_ALL, sub {
        my ($self, $evt) = @_;
        my $lstctrl = $self->{'simple_textctrl'};
        my $line = -1;
        foreach my $i (0.. $lstctrl->GetItemCount () - 1){
            $lstctrl->SetItemState ($i, wxLIST_STATE_SELECTED,wxLIST_STATE_SELECTED);
        }
        $lstctrl->Refresh ();
    });

    my $acceltab = new Wx::AcceleratorTable (
        [wxACCEL_CTRL, ord 'A', $ID_SELECT_ALL],
        [wxACCEL_CTRL, ord 'C', $ID_COPY]
        );

    $self->SetAcceleratorTable ($acceltab);


    #
    #   Expert View -Tab
    #
    
    $self->{'expertview_page'} = Wx::Panel->new($self->{'masterNotebook'},-1,);
    
    $self->{'masterNotebook'}->AddPage($self->{'expertview_page'},$notebooklist[1], 0);

    my $expertlog_Sizer = Wx::FlexGridSizer->new(4,1,5,5);

        #
        #   Search Box
        #
        
        $self->{'search_StaticBox'} = Wx::StaticBox->new ($self->{'expertview_page'},-1,'Text Search',);
        my $searchSizer = Wx::StaticBoxSizer->new($self->{'search_StaticBox'},wxHORIZONTAL);
        $self->{'search_label'} = Wx::StaticText->new ($self->{'expertview_page'}, -1, 'Find:');
        $self->{'search_textctrl'} = Wx::TextCtrl->new ($self->{'expertview_page'}, -1,'',[-1,-1],[-1,-1],wxTE_PROCESS_ENTER );
        $self->{'search_next_button'} = Wx::Button->new ($self->{'expertview_page'}, -1, 'Next');
        $self->{'search_previous_button'} = Wx::Button->new ($self->{'expertview_page'}, -1, 'Previous');
        $self->{'search_highlightall_button'} = Wx::Button->new ($self->{'expertview_page'}, -1, 'Highlight all');
        $self->{'search_matchcase_checkbox'} = Wx::CheckBox->new ($self->{'expertview_page'}, -1, 'Match Case');
        $searchSizer->Add ($self->{'search_label'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $searchSizer->Add ($self->{'search_textctrl'},1, wxEXPAND | wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $searchSizer->Add ($self->{'search_matchcase_checkbox'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $searchSizer->Add ($self->{'search_next_button'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $searchSizer->Add ($self->{'search_previous_button'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $searchSizer->Add ($self->{'search_highlightall_button'},0,wxALIGN_CENTER_VERTICAL | wxLEFT, 5);
        $expertlog_Sizer->Add ($searchSizer, 1, wxEXPAND );
        
        #
        #   Content Box
        #
        
        #$self->{'content_splitterv'} = Wx::SplitterWindow->new ($self->{'expertview_page'},-1,);
        $self->{'content_splitterh'} = Wx::SplitterWindow->new ($self->{'expertview_page'},-1,);
        
        $self->{'content_tree'} = SDB::Install::LogViewer::Control::XLVTreeCtrl->new($self->{'content_splitterh'}, -1);
        $self->{'content_tree'}->SetFont(Wx::Font->new(10, wxTELETYPE, wxNORMAL, wxNORMAL));
        $self->{'content_details_tree'} = SDB::Install::LogViewer::Control::XLVTreeDetailsCtrl->new($self->{'content_splitterh'}, -1,);
        #$self->{'content_textctrl'} = SDB::Install::LogViewer::Control::XLVListCtrl->new($self->{'content_splitterv'}, -1,[-1,-1],[-1,-1], wxLC_REPORT | wxLC_VIRTUAL | wxLC_NO_HEADER  );
        
        $self->{'content_splitterh'}->SplitVertically($self->{'content_tree'}, $self->{'content_details_tree'});
        #$self->{'content_splitterv'}->SplitHorizontally($self->{'content_splitterh'}, $self->{'content_textctrl'});
        
        #$self->{'content_splitterv'}->SetMinimumPaneSize(20);
        $self->{'content_splitterh'}->SetMinimumPaneSize(20);
        
		#$self->{'content_splitterv'}->SetSashGravity(1);

        #
        # set initial splitter ratio to 7/10
        #
        $self->{'content_splitterh'}->SetSize ([100,100]);
        $self->{'content_splitterh'}->SetSashPosition (70);

        $self->{'content_splitterh'}->SetSashGravity(0.5);

        $expertlog_Sizer->Add ($self->{'content_splitterh'}, 1, wxEXPAND);
        
        #
        #   Filter Box
        #

        $self->{'filter_StaticBox'} = Wx::StaticBox->new ($self->{'expertview_page'},-1,'Filter',);
        my $filterSizerV = Wx::StaticBoxSizer->new($self->{'filter_StaticBox'}, wxVERTICAL);
        my $filterSizerH = Wx::FlexGridSizer->new(1,8,0,0);
        
        $self->{'filter_list'} = Wx::ListCtrl->new( $self->{'expertview_page'}, -1, [0,0],[-1,-1], wxLC_REPORT | wxLC_SINGLE_SEL);
        $self->{'filter_list'}->InsertColumn( 1, "Category" );
        $self->{'filter_list'}->InsertColumn( 2, "Filter" );
        $self->{'filter_list'}->InsertColumn( 3, "Enable" );
        $self->{'filter_list'}->InsertColumn( 4, "ID" );
        $filterSizerV->Add ($self->{'filter_list'}, 1, wxEXPAND );

        $self->{'filter_button'} = Wx::Button->new ($self->{'expertview_page'}, -1, 'Add Filter');
        $self->{'filter_button'}->Enable(0);
        $self->{'filter_combo'} = Wx::ComboBox->new ($self->{'expertview_page'}, -1,'',[-1,-1],[-1,-1],SDB::Install::LogViewer::Filter::FilterHandler::GetFilterTitelsAsAnRefArray(), wxCB_READONLY );
        $self->{'delete_button'} = Wx::Button->new($self->{'expertview_page'},-1,'Delete Selected Filter');
        $self->{'delete_button'}->Enable(0);
        $self->{'delete_all_button'} = Wx::Button->new($self->{'expertview_page'},-1,'Delete All Filter');
        $self->{'disEnable_checkbox'} = Wx::CheckBox->new($self->{'expertview_page'},-1,'Enable Filter');
        $self->{'disEnable_checkbox'}->Enable(0);
        
        $filterSizerH->Add ($self->{'filter_combo'},0, wxALIGN_CENTER_VERTICAL );
        $filterSizerH->Add ($self->{'filter_button'},0, wxALIGN_CENTER_VERTICAL);
        $filterSizerH->AddSpacer(15);
        $filterSizerH->Add ($self->{'delete_button'},0,wxALIGN_CENTER_VERTICAL );
        $filterSizerH->AddSpacer(5);
        $filterSizerH->Add ($self->{'delete_all_button'},0,wxALIGN_CENTER_VERTICAL );
        $filterSizerH->AddSpacer(15);
        $filterSizerH->Add ($self->{'disEnable_checkbox'},0, wxALIGN_CENTER_VERTICAL | wxALL, 5);
        
        $filterSizerV->Add ($filterSizerH, 0, wxTOP,5 );
        
        $expertlog_Sizer->Add ($filterSizerV, 1, wxEXPAND );
        
    $expertlog_Sizer->AddGrowableRow( 1 );
    $expertlog_Sizer->AddGrowableCol( 0 );
        
    $self->{'expertview_page'}->SetSizer($expertlog_Sizer);
    
    $self->SetSizerAndFit($nbsizer);
    
    #---------Events------------

    EVT_NOTEBOOK_PAGE_CHANGED($self,$self->{'masterNotebook'}->GetId(),\&OnNotebookChange);
    
    #
    #   Splitter window events
    #    

    EVT_TREE_SEL_CHANGED($self, $self->{'content_tree'}->GetId(), \&OnTreeSelect);
    EVT_TREE_ITEM_EXPANDING ($self, $self->{'content_tree'}->GetId(), \&OnTreeExpand);
    
    #
    #   Filter events
    #
    
    EVT_COMBOBOX($self, $self->{'filter_combo'}->GetId(), \&OnFilterSelected);
    EVT_BUTTON($self, $self->{'filter_button'}->GetId(), \&OnAddFilter);
    EVT_BUTTON($self, $self->{'delete_button'}->GetId(), \&OnDeleteFilter);
    EVT_BUTTON($self, $self->{'delete_all_button'}->GetId(), \&OnDeleteAllFilter);
    EVT_CHECKBOX ($self, $self->{'disEnable_checkbox'}->GetId(), \&OnCheckDisEnableFilter);
    EVT_LIST_ITEM_SELECTED($self, $self->{'filter_list'}->GetId(), \&OnFilterListSelected);

    #
    #   Simple Find events
    #    

    EVT_BUTTON($self, $self->{'simplesearch_next_button'}->GetId(), \&OnSimpleNextButton );
    EVT_BUTTON($self, $self->{'simplesearch_previous_button'}->GetId(), \&OnSimplePreviousButton );
    EVT_TEXT ($self, $self->{'simplesearch_textctrl'}->GetId(), \&OnSimpleSearchTextChange );
    EVT_TEXT_ENTER ($self, $self->{'simplesearch_textctrl'}->GetId(), \&OnSimpleSearchTextEnter);
    
    #
    #   Expert Find events
    #    

    EVT_BUTTON($self, $self->{'search_next_button'}->GetId(), \&OnNextButton );
    EVT_BUTTON($self, $self->{'search_previous_button'}->GetId(), \&OnPreviousButton );
    EVT_BUTTON($self, $self->{'search_highlightall_button'}->GetId(), \&OnHighlightAllButton );
    EVT_TEXT ($self, $self->{'search_textctrl'}->GetId(), \&OnSearchTextChange );
    EVT_TEXT_ENTER ($self, $self->{'search_textctrl'}->GetId(), \&OnSearchTextEnter);
    
    #
    #   Copy
    #
    
    EVT_LIST_ITEM_RIGHT_CLICK ($self, $self->{'simple_textctrl'}, \&OnSimpleCopyMenu);
    EVT_LIST_ITEM_SELECTED ($self, $self->{'simple_textctrl'}, \&OnSimpleItemSelected);
    EVT_LIST_ITEM_DESELECTED ($self, $self->{'simple_textctrl'}, \&OnSimpleItemDeselected);
    
    EVT_TREE_ITEM_RIGHT_CLICK ($self, $self->{'content_tree'}, \&OnTreeItemRMB);
    
    #
    #   Enable/Disable filter functions
    #
    
    
    EVT_LIST_ITEM_SELECTED ($self, $self->{'filter_list'}, sub {
                                                                $self->{'delete_button'}->Enable(1);
                                                                $self->{'disEnable_checkbox'}->Enable(1);
                                                                });
    EVT_LIST_ITEM_DESELECTED ($self, $self->{'filter_list'}, sub {
                                                                $self->{'delete_button'}->Enable(0);
                                                                $self->{'disEnable_checkbox'}->Enable(0);
                                                                });
    
    #--------Other Stuff---------
    
    $self->SetSearchAndFilter(0); # disable search and filter elements for the first time
    $self->{'humanselect'} = -1;
    $self->SetAutoLayout(1);
    $self->Layout();
    $self->Show(0);
    $self;
}

#------------------------------- Public methods -----------------------------


##
# Set to load file after dialog is visible.
#
# @param
#   scalar scal - filename
##

sub LoadFileAfterShow {
    my( $self, $scal ) = @_;
    $self->{LOADFILELATER} = $scal;
    1;
}


##
# Set to load content from scalar after dialog is visible.
#
# @param
#   scalar scal - scalar with content
##

sub LoadScalarAfterShow {
    my( $self, $scal ) = @_;#
    $self->{LOADSCALARLATER} = $scal;
    1;
}

sub LoadMsgLstAfterShow {
	$_[0]->{LOADMSGLSTLATER} = $_[1];
	1;
}




##
# Set to load explicit simple view content from scalar after dialog is visible.
#
# @param
#   scalar scal - scalar with plaint text for simple view
##

sub LoadPlainTextAfterShow {
    my( $self, $scal ) = @_;
    $self->{LOADPLAINTEXT} = $scal;
    1;
}


##
# Load content from file.
# Do not call this method from an other modul.
#
# @param
#   scalar filename - filename
##

sub LoadFile {
    my ($self, $filename) = @_;
 
    #message
    $self->SetMessage("Loading file $filename, please wait...");
        
    #Load from File
    #$self->SetMessage("Load from File");
    my $result = $self->{CACHE}->LoadFromFile ( $filename );
    #$self->SetMessage("Load from Done");
    if (( $result ne '1') && ($result ne '2') ) {
        $self->SetMessage( $result );    
    } 
    
    #
    # Destroy all filters
    #
        
    $self->{FILTERHANDLER}->DestroyAllFilters();
    $self->{'filter_list'}->DeleteAllItems();
    
    #
    # Reset Find
    #
    #$self->SetMessage("Reset Find");
    $self->{FIND}->Reset;
    
    #
    #   Set gui elements enable
    #
    #$self->SetMessage("Set gui elements enable");
    $self->SetSearchAndFilter(1);
    
    if ($result eq '2') {
        $self->SetExpertElements (0);
        
        #
        # Fill simple text                       
        #
        my $lala = $self->{CACHE}->{content};
        $self->{'simple_textctrl'}->SetValue( $lala );
        $self->{'simple_textctrl'}->ShowPosition(0);
        
        #
        # Fill Expert View if require
        #
        #$self->SetMessage("Fill Expert View if require"); 
        $self->{'content_tree'}->Reset();
        
        #$self->{'content_textctrl'}->DeleteAllItems();
        $self->{'content_details_tree'}->DeleteAllItems();
        $self->{'content_tree'}->DeleteAllItems();
        
    } else {
        $self->SetExpertElements (1);
        
        #
        # Fill simple text                       
        #
        my $lala = $self->{CACHE}->GetPlainText();
        $self->{'simple_textctrl'}->SetValue( $lala );
        $self->{'simple_textctrl'}->ShowPosition(0);
        
        #
        # Fill Expert View if require
        #
        #$self->SetMessage("Fill Expert View if require"); 
        $self->{'content_tree'}->Reset();
        
        my $lolo = $self->{CACHE}->GetContentWithLines();
        #$self->{'content_textctrl'}->SetValue( $lolo );    
        # fill tree
        #$self->SetMessage("fill tree");
        #$self->{'content_tree'}->InitiateTree( $self->{CACHE} );  
    }
        
    $self->SetMessage("Load file done.");    
    $self->Layout();  
    1;
}

#------------------------------- gui methods ----------------------------

sub SetMessage() {
    my( $self, $message, $break ) = @_;
    if ($self->GetParent->can("SetMessage")) {
        $self->GetParent->SetMessage($message, $break);
    }
    1;
}

##
# Updates the filter list. 
##

sub UpdateFilterTable() {
    my ($self) = @_;
    
    #
    # Clear list
    #
    
    $self->{'filter_list'}->DeleteAllItems;
    
    #
    # Fill list
    #
    
    my $count = 0;
    my @list = $self->{FILTERHANDLER}->GetFilterTable();
    foreach my $element (@list) {
         my $col = $self->{'filter_list'}->InsertStringItem($count++,$element->{'CATEGORY'});
         $self->{'filter_list'}->SetItem($col,1,$element->{'FILTER'});
         $self->{'filter_list'}->SetItem($col,2,($element->{'ENABLE'} eq 1)?('True'):('False'));
         $self->{'filter_list'}->SetItem($col,3,$element->{'ID'});
    }
    $self->{'filter_list'}->SetColumnWidth(0,-2);
    $self->{'filter_list'}->SetColumnWidth(1,-1);
    $self->{'filter_list'}->SetColumnWidth(2,-2);
    $self->{'filter_list'}->SetColumnWidth(3,-2);
    
    1;
}


my @EnableDisableSearchElements = (
                                'simplesearch_label',
                                'simplesearch_textctrl',
                                'simplesearch_next_button',
                                'simplesearch_previous_button',
                                'simplesearch_matchcase_checkbox',
                                'filter_combo',
                                'search_label',
                                'search_textctrl',
                                'search_next_button',
                                'search_previous_button',
                                'search_highlightall_button',
                                'search_matchcase_checkbox',
                                'delete_all_button',
                                );


##
# Disable or enable search and filter gui elements.
#
# @params
#   scalar onoff - if 0 then all off, if 1 then all on
##

sub SetSearchAndFilter() {
    my ($self, $onoff) = @_;
    foreach my $element (@EnableDisableSearchElements) {
        $self->{$element}->Enable( $onoff );
    }
    1;
}


my @EnableDisableExpertsElements = (
                                'search_StaticBox',
                                'search_label',
                                'search_textctrl',
                                'search_next_button',
                                'search_previous_button',
                                'search_highlightall_button',
                                'search_matchcase_checkbox',
                                'content_tree',
                                'content_details_tree',
                                #'content_textctrl',
                                'filter_StaticBox',
                                'filter_list',
                                'filter_button',
                                'filter_combo',
                                'delete_button',
                                'delete_all_button',
                                'disEnable_checkbox',
                                'expertview_page',
                                );


##
# Disable or enable search and filter gui elements.
#
# @params
#   scalar onoff - if 0 then all off, if 1 then all on
##

sub SetExpertElements() {
    my ($self, $onoff) = @_;

    foreach my $element (@EnableDisableExpertsElements) {
        $self->{$element}->Enable( $onoff );
    }
    1;
}


##
# Get the current selected line of a Wx::ListCtrl.
#
# @params
#   Wx::ListCtrl - ListCtrl
#
# @return 
#   scalar       - line number of current selected line, 0 if no such item found
##

sub GetSelectedLine() {
    my ($self, $listctrl) = @_;
    
    return unless ($listctrl);
    
    #
    # Find selected line
    #
    
    my $line = -1;
    $line = $listctrl->GetNextItem($line,
                                     wxLIST_NEXT_ALL,
                                     wxLIST_STATE_SELECTED);
    return $line + 1;
}

#------------------------ dialog event methods ---------------------------


##
# This method copy the given text to the clipboard.
##

sub ToClipBoard{
    my ($text) = @_;
    eval {
        require Wx::DND;
    };
    if (!$@) {
        wxTheClipboard->Open;
        my $result = Wx::TextDataObject->new($text);
        wxTheClipboard->SetData( $result );
        wxTheClipboard->Close;
    }
}


##
# Event method for tree view right mouse button menu.
##

sub OnTreeItemRMB {
    my ($self, $evt) = @_;

    my @selections = $self->{'content_tree'}->GetSelections();

    if (!@selections){
        return;
    }

    $self->{menu} = Wx::Menu->new();
    my $ID_COPYTEXT = 12222;
    my $ID_COPYTEXTWH = 12223;
    my $ID_COPYDETAILS = 12224;
    
    $self->{menu}->Append($ID_COPYTEXT, 'Copy text' );

    if (@selections == 1){
        $self->{menu}->Append($ID_COPYTEXTWH, 'Copy text with hierarchy' );
        $self->{menu}->Append($ID_COPYDETAILS, 'Copy text with details' );
    }
    my $linewrap = $isWin ? "\r\n" : "\n";
    EVT_MENU($self, $ID_COPYTEXT, sub {
                                                my ($self, $evt) = @_;
                                                my $text;
                                                my $linewrap = $isWin ? "\r\n" : "\n";
                                                foreach my $item (@selections) {
                                                    $text .= ($text ? $linewrap : '' ) . $self->{'content_tree'}->GetItemText ($item);

                                                }
                                                ToClipBoard($text);
                                            });
    EVT_MENU($self, $ID_COPYTEXTWH, sub {
                                                    my ($self, $evt) = @_;
                                                    my @array = $self->{'content_tree'}->GetItemTextWithHierarchy($selections[0]);
                                                    my $text;
                                                    my $offset="";
                                                    foreach my $line (reverse @array) {
                                                        $text .= $offset.$line.$linewrap;
                                                        $offset.="\t";
                                                    }
                                                    chomp $text;
                                                    chop $text if($isWin);
                                                    ToClipBoard($text);
                                            });
    EVT_MENU($self, $ID_COPYDETAILS, sub {
                                                    my ($self, $evt) = @_;
                                                    my $text = $self->{'content_tree'}->GetItemText($selections[0]);

                                                    $text.= $linewrap;
                                                    my @details = $self->{'content_details_tree'}->GetDetailsAsText();
                                                    foreach my $detail (@details) {
                                                        $text .= "\t".$detail.$linewrap;
                                                    }
                                                    chomp $text;
                                                    chop $text if($isWin);
                                                    ToClipBoard($text);
                                            });
                                            
    $self->{'content_tree'}->PopupMenu( $self->{menu}, $evt->GetPoint() );
    $evt->Skip();
    1;    
}

##
# Event methods for simple and content listctrl...
##

sub OnSimpleItemSelected {
    my ($self, $evt) = @_;

my $id = $isWin ?($evt->GetItem()->GetId()):($evt->GetIndex());

    if ($self->{'simple_textctrl'}->GetSelectedItemCount() == 1) {
        delete $self->{'simple_textctrl'}->{'simplelist'};
    }
    $self->{'simple_textctrl'}->{'simplelist'}->{$id} = $evt->GetText();

    # for searching
    $self->{SIMPLEFIND} = $id;
    1;
}

sub OnSimpleItemDeselected {
    my ($self, $evt) = @_;

my $id = $isWin ? ($evt->GetItem()->GetId()):($evt->GetIndex());
    delete $self->{'simple_textctrl'}->{'simplelist'}->{$id};

    1;
}

sub OnContentItemSelected {
    my ($self, $evt) = @_;
    
    if ($self->{'humanselect'} == -1) {$self->{'humanselect'} = 1;}
    if ($self->{'humanselect'} == 2) {
        $self->{'humanselect'} = -1;
        return 1;
    }
    
    #
    #   Save for copy
    #
    
    my $id = $isWin ? ($evt->GetItem()->GetId()):($evt->GetIndex());
    
    if ($self->{'content_textctrl'}->GetSelectedItemCount() == 1) {
        delete $self->{'content_textctrl'}->{'contentlist'};
    }
    
    $self->{'content_textctrl'}->{'contentlist'}->{$id} = $evt->GetText();  

    #
    #   select tree node if possible
    #
    
    $self->{'content_tree'}->SelectBestTreeNodeBySourceline($id+1);

    1;
}

sub OnContentItemDeselected {
    my ($self, $evt) = @_;

my $id = $isWin ? ($evt->GetItem()->GetId()):($evt->GetIndex());
    delete $self->{'content_textctrl'}->{'contentlist'}->{$id};
    1;
}
    

sub GetSelectedContentListItems {
    my ($self) = @_;
    my $result = {};
    
    foreach ( 0 .. $self->{'content_textctrl'}->GetItemCount - 1 ) {
        my $i = $_;
        if ($self->{'content_textctrl'}->GetItemState( $i, wxLIST_STATE_SELECTED )) { 
            ($result->{$i}) = $self->{'content_textctrl'}->GetItemText($i);  
        }
    }
    return $result;
}

sub GetSelectedSimpleListItems {
    my ($self) = @_;
    my @result;
    
    foreach ( 0 .. $self->{'simple_textctrl'}->GetItemCount - 1 ) {
        my $i = $_;
        if ($self->{'simple_textctrl'}->GetItemState( $i, wxLIST_STATE_SELECTED )) { 
            push @result, $self->{'simple_textctrl'}->GetItemText($i);  
        }
    }
    return \@result;
}


##
# Copy menu for selected list lines
##

sub OnSimpleCopyMenu{
    my ($self, $evt) = @_;
    $self->{'simple_textctrl'}->PopupMenu( $self->{menu}, $evt->GetPoint() );
    1;
}


##
# method for init start 
##

sub OnInit {
    my ($self) = @_;
	if (exists $self->{LOADMSGLSTLATER}){
		$self->SetMessage("Loading MsgLst, please wait...");
		my $result = $self->{CACHE}->LoadFromMsgLst ( $self->{LOADMSGLSTLATER} );
		if ( $result ne "1" ) {
			$self->SetMessage( $result );
		}
		$self->SetSearchAndFilter(1);
		$self->SetExpertElements (0);
		$self->SetMessage( "Load done.");
		$self->{'simple_textctrl'}->SetValue( ${$self->{LOADMSGLSTLATER}->getMsgLstString ('',1,1)});
		$self->{'simple_textctrl'}->ShowPosition(0);
		delete $self->{LOADMSGLSTLATER};
	}
    elsif ( exists $self->{LOADFILELATER} ) {
        #message
        $self->SetMessage("Loading file ".$self->{LOADFILELATER}.", please wait...");
        
        #Load from File
        my $result = $self->{CACHE}->LoadFromFile ( $self->{LOADFILELATER} );
        delete $self->{LOADFILELATER};
        if ( $result ne "1" ) {
            $self->SetMessage( $result );
        } 
        $self->SetSearchAndFilter(1);
        $self->SetExpertElements (0);
        $self->SetMessage( "Load done.");
        
        $self->{'simple_textctrl'}->SetValue( $self->{CACHE}->GetPlainText() );
        $self->{'simple_textctrl'}->ShowPosition(0);
    } elsif ( exists $self->{LOADSCALARLATER} ) {
        #message
        $self->SetMessage("Loading log, please wait...");
        
        #Load file from Scalar direct
        my $result = $self->{CACHE}->LoadFromScalar ( $self->{LOADSCALARLATER} );
        delete $self->{LOADSCALARLATER};
        if ( $result ne "1" ) {
            $self->SetMessage( $result );
        }
        $self->SetSearchAndFilter(1);
        $self->SetMessage( "Load done.");
                
        #$self->SetMessage( "Set simple view...");
        if (exists $self->{LOADPLAINTEXT} ) {
        
            #Load plain text direct
            $self->{'simple_textctrl'}->SetValue( $self->{LOADPLAINTEXT} ); 
            delete $self->{LOADPLAINTEXT};
            
        } else {
            
            #Load plain text indirect from chache
            $self->{'simple_textctrl'}->SetValue( $self->{CACHE}->GetPlainText() );
        }
        $self->{'simple_textctrl'}->ShowPosition(0);
        #$self->SetMessage( "Set simple view done.");

    } elsif (exists $self->{LOADPLAINTEXT} ) {
        #Load plain text direct
        $self->{'simple_textctrl'}->SetValue( $self->{LOADPLAINTEXT} ); 
        delete $self->{LOADPLAINTEXT};
        $self->{'simple_textctrl'}->ShowPosition(0);
        #$self->SetMessage( "Set simple view done.");
        
    }
    
    $self->Layout();
#     $self->{'simplesearch_textctrl'}->SetFocus();
    1;
}

##
# Event method for change tab.
##

sub OnNotebookChange() {
    my ($self,$event) = @_;
    #Expert View  
    if ($self->{'masterNotebook'}->GetPageText($self->{'masterNotebook'}->GetSelection()) eq $notebooklist[1]) {
        if (defined $self->{CACHE}->GetCacheTree) {
            $self->SetExpertElements (1);
            # fill sourcecode
            #if ($self->{'content_textctrl'}->GetMaxLine == 0) {
            #    $self->{'content_textctrl'}->SetValue( $self->{CACHE}->GetContentWithLines() );
            #}

            # fill tree
            if (!$self->{initialized}){
				#print ">>>> DOIT\n";
				$self->{'content_tree'}->InitiateTree( $self->{CACHE} );
            }
			$self->{initialized} = 1;
						
			$self->ApplyFilterChanges();
        }
        $self->{'search_textctrl'}->SetFocus();
    } else {
        $self->{'simplesearch_textctrl'}->SetFocus();
    }
    
    1;
}


##
# Event method for loading file
##

sub OnLoad {
    my ($self,$evt) = @_;
    
    my $filedlg = Wx::FileDialog->new($self,'Choose a file', );
    $filedlg->ShowModal;
    my $result = $filedlg->GetPath;
    $self->LoadFile ($result) if $result;
    
    1;
}


##
# Event method for content tree selection.
##
 
sub OnTreeSelect{
   my ($self, $event) = @_;

   if ($self->{'humanselect'} == -1) {$self->{'humanselect'} = 2;}
   if ($self->{'humanselect'} == 1) {
       $self->{'humanselect'} = -1;
       return 1;
   }

   if (!$event->GetItem ()->IsOk()){
        return 1;
   }

   #
   # get item line number from selected content tree data
   #
   
   my $pldata = $self->{'content_tree'}->GetPlData($event->GetItem);
   my $line = $pldata->{'Sourceline'};
   #unless ($line) {
   #     $self->{'content_details_tree'}->DeleteAllItems();
   #     return 0;       
   #}
   
   #
   # Scroll to position in source text and fill detail view with data
   #
   # Without this work around the line to show is bottom not on top
   #$self->{'content_textctrl'}->ShowPosition($self->{'content_textctrl'}->GetMaxLine() -1) if ($^O !~ /mswin/i);
   
   #   deselect all lines
   #foreach ( 0 .. $self->{'content_textctrl'}->GetItemCount - 1 ) {
   #   $self->{'content_textctrl'}->SetItemState( $_, 0, wxLIST_STATE_SELECTED );
   #}
       
   #   Scroll to line
   #$self->{'content_textctrl'}->ShowPosition($line -1);

   # Fill Details
   $self->{'content_details_tree'}->FillDetails($pldata);
   
   #   select line
   #$self->{'content_textctrl'}->SetItemState($line -1, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
   
   1;
}

##
# Event method for content tree expanding.
##

sub OnTreeExpand {
    my ($self,$event) = @_;
    my $node = $event->GetItem();
    if ($node->IsOk) {
        $self->{'content_tree'}->Expand( $node );
        
        # if enable then search for highlighting
        if ($self->{FIND}->isHighlightingEnable) {
            $self->{FIND}->SearchHighlightString(
                                $node,
                                $self->{'content_tree'},
                                quotemeta ($self->{search_textctrl}->GetValue ()),
                                $self->{'search_matchcase_checkbox'}->GetValue()
                                );            
        }
    }
}

#------------------------ filter event methods ---------------------------


##
# Call this method after any filter changes
##

sub ApplyFilterChanges{
    my ($self) = @_;
    
    $self->{FILTERHANDLER}->ApplyAllFilterNow($self->{'content_tree'}, $self->{CACHE});
        
    $self->{FIND}->Reset;

    $self->{'content_tree'}->LayoutIt();

    $self->UpdateFilterTable();
    
    1;
}


##
# Event method for filter list selection.
# Sets the enable status checkbox constrained on the filter status.
##

sub OnFilterListSelected() {
    my ($self,$event) = @_;
    
    #
    # is something selected?
    #
    
    my $line = $self->GetSelectedLine($self->{'filter_list'});
    return if ($line eq 0);
  
    #
    # set enable checkbox status from filter status
    #
      
    my $item = $self->{'filter_list'}->GetItem($line-1,2);
    my $status = $item->GetText();
    $self->{'disEnable_checkbox'}->SetValue(($status eq 'True')?(1):(0));
    
    1; 
}


##
# Event method for delete filter button.
##

sub OnDeleteFilter() {
    my ($self,$event) = @_;
    
    #  
    # is something selected?
    #
    
    my $line = $self->GetSelectedLine($self->{'filter_list'});
    return if ($line eq 0);
    
    #
    # delete current selected filter
    #
    
    my $item = $self->{'filter_list'}->GetItem($line-1,3);
    my $id = $item->GetText();
    $self->{FILTERHANDLER}->DestroyFilter($id);
    
    $self->ApplyFilterChanges();
    
    1;
}


##
# Event method for delete all filter button.
##

sub OnDeleteAllFilter() {
    my ($self,$event) = @_;
    
    $self->{FILTERHANDLER}->DestroyAllFilters(); # clear filters
    $self->{'filter_list'}->DeleteAllItems(); # clear listctrl
    
    $self->ApplyFilterChanges();
    
    1;
}


##
# Event method for changing filter enable status.
##

sub OnCheckDisEnableFilter() {
    my ($self,$event) = @_;
    
    #
    # is something selected?
    #
    
    my $line = $self->GetSelectedLine($self->{'filter_list'});
    return if ($line eq 0);
    
    #
    # Set new enable status
    #
    
    my $item = $self->{'filter_list'}->GetItem($line-1,3);
    my $id = $item->GetText();
    $self->{FILTERHANDLER}->SwitchEnable($id);
    
    $self->ApplyFilterChanges();
     
    1;
}


##
# Event method for add filter button.
# This method opens the dialog for the current selected filter. 
##

sub OnAddFilter {
    my ($self,$event) = @_;
    
    $self->{FILTERHANDLER}->OpenFilterDialog ($self->{'filter_combo'}->GetValue(), $self->{CACHE} );
    
    $self->ApplyFilterChanges();
    
    1;
}


##
# Event method for filter selection.
# The only function is to enable the add filter button.
##

sub OnFilterSelected {
    my ($self,$event) = @_;
    
    $self->{'filter_button'}->Enable(1);
    
    1;
}

#-------------------------- find event methods ---------------------------


##
# Event method for simple search text enter 
##

sub OnSimpleSearchTextEnter {
    my ($self) = @_;
    $self->{'simplesearch_next_button'}->SetFocus();
    $self->OnSimpleNextButton();
    1;
}

##
# Event method for simple search text change 
##

sub OnSimpleSearchTextChange {
    my ($self) = @_;
    if (defined $self->{SIMPLEFIND}) { delete $self->{SIMPLEFIND}; };
    1;
}

##
# Event method for simple find next button.
##

sub OnSimpleNextButton() {
    my ($self,$event) = @_;
    $self->SimpleSearch('NEXT');
    1;
}


##
# Event method for simple find previous button.
##

sub OnSimplePreviousButton() {
    my ($self,$event) = @_;
    $self->SimpleSearch('PREVIOUS');
    1;
}


##
# Search method for simple list ctrl.
##

sub SimpleSearch {
    my ($self, $direction) = @_;
    
    if (!defined $self->{SIMPLEFIND}) { $self->{SIMPLEFIND} = 0; };
    
    my $startvalue = $self->{SIMPLEFIND};
    my $max = $self->{'simple_textctrl'}->GetItemCount()-1;
    my $result = 0;
    
    #
    #   set $self->{SIMPLEFIND} value
    #
    if ($direction eq 'NEXT') {
        $self->{SIMPLEFIND}++;
    } else {
        $self->{SIMPLEFIND}--;
    }
    if ($self->{SIMPLEFIND}<0) { $self->{SIMPLEFIND} = $max; }
    if ($self->{SIMPLEFIND}>$max) { $self->{SIMPLEFIND} = 0; }
        
    while (($result == 0) && ($self->{SIMPLEFIND} != $startvalue)) {
    
        #
        #   get item text
        #
        my $text = $self->{'simple_textctrl'}->GetItem($self->{SIMPLEFIND})->GetText();

        #
        #   search
        #
        my $searchstring = quotemeta ($self->{simplesearch_textctrl}->GetValue ());
        if ($self->{'simplesearch_matchcase_checkbox'}->GetValue()) {
            if ($text =~ /$searchstring/) {
                $result = 1;
            }
        } else {
            if ($text =~ /$searchstring/i) {
                $result = 1;
            }
        } 
        
        #
        #   set $self->{SIMPLEFIND} value
        #
        if ($result != 1) {
            if ($direction eq 'NEXT') {
                $self->{SIMPLEFIND}++;
            } else {
                $self->{SIMPLEFIND}--;
            }
            if ($self->{SIMPLEFIND}<0) { $self->{SIMPLEFIND} = $max; }
            if ($self->{SIMPLEFIND}>$max) { $self->{SIMPLEFIND} = 0; }
        }
    }
    
    #    set search text colour
    if ($result == 0) {
        $self->{'simplesearch_textctrl'}->SetBackgroundColour(wxRED);
        $self->{'simplesearch_textctrl'}->Refresh();
        return 1;
    } else {
        $self->{'simplesearch_textctrl'}->SetBackgroundColour(wxWHITE);
        $self->{'simplesearch_textctrl'}->Refresh();
    }
    
    
    #
    #   Select line
    #
    
    #   deselect all lines
    foreach ( 0 .. $self->{'simple_textctrl'}->GetItemCount - 1 ) {
        $self->{'simple_textctrl'}->SetItemState( $_, 0, wxLIST_STATE_SELECTED );
    }
    
    #   Scroll to line
    $self->{'simple_textctrl'}->ShowPosition($self->{SIMPLEFIND});
    
    #   select line
    $self->{'simple_textctrl'}->SetItemState($self->{SIMPLEFIND}, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
    
    1;
}


##
# Event method for expert search text enter 
##

sub OnSearchTextEnter {
    my ($self) = @_;
    $self->{'search_next_button'}->SetFocus();
    $self->OnNextButton();
    1;
}

##
# Event method for expert search text change 
##

sub OnSearchTextChange {
    my ($self) = @_;
    $self->{FIND}->Reset;
    1;
}

##
# Event method for expert find next button.
##

sub OnNextButton() {
    my ($self,$event) = @_;
    $self->Search('NEXT');
    1;
}


##
# Event method for expert find previous button.
##

sub OnPreviousButton() {
    my ($self,$event) = @_;
    $self->Search('PREVIOUS');
    1;
}


##
# Start searching for expert next or previous matching string.
#
# @params
#   scalar flag - 'NEXT' or 'PREVIOUS'
##

sub Search () {
    my ($self, $flag) = @_;
    
    return if ($self->{'search_textctrl'}->GetValue() eq '');
    
    #
    # find node
    #    
    
    my $resultnode; # found node
    if ($flag eq 'NEXT') {
        $resultnode = $self->{FIND}->FindNext(
                            ($self->{'content_tree'}->GetSelections())[0],
                            $self->{'content_tree'},
                            $self->{CACHE},
                            quotemeta ($self->{search_textctrl}->GetValue ()),
                            $self->{'search_matchcase_checkbox'}->GetValue()
                            );
    } elsif ('PREVIOUS') {
        $resultnode = $self->{FIND}->FindPrevious(
                            ($self->{'content_tree'}->GetSelections())[0],
                            $self->{'content_tree'},
                            $self->{CACHE},
                            quotemeta ($self->{search_textctrl}->GetValue ()),
                            $self->{'search_matchcase_checkbox'}->GetValue()
                            );    
    } else {
        return;
    }
    
    #
    # process node
    #
    
    if ($resultnode eq -1) { # no node found
        $self->{'search_textctrl'}->SetBackgroundColour(wxRED);        
        $self->{'search_textctrl'}->Refresh();
    } else {
        $self->{'content_tree'}->SelectTreeNode($resultnode);
        $self->{'content_tree'}->Refresh();
        $self->{'content_tree'}->Update();
        $self->{'search_textctrl'}->SetBackgroundColour(wxWHITE);
        $self->{'search_textctrl'}->Refresh(); 
    }
    
    1;
}


##
# Event method for the highlight all button.
##
        
sub OnHighlightAllButton() {
    my ($self, $event) = @_;
    
    if ($self->{'search_textctrl'}->GetValue() eq '') { # dehighlight all
        $self->{FIND}->TrashHighlights($self->{'content_tree'});
        $self->{'search_textctrl'}->SetBackgroundColour(wxWHITE);
        $self->{'search_textctrl'}->Refresh(); 
    } else { # search and highlight all
        $self->{FIND}->HighlightAll(
                                $self->{'content_tree'},
                                quotemeta ($self->{search_textctrl}->GetValue ()),
                                $self->{'search_matchcase_checkbox'}->GetValue()
                                );
        #if ($result eq 0) { # no node found
        #    $self->{'search_textctrl'}->SetBackgroundColour(wxRED);        
        #    $self->{'search_textctrl'}->Refresh();
        #} elsif($result eq 1) {
        #    $self->{'search_textctrl'}->SetBackgroundColour(wxWHITE);
        #    $self->{'search_textctrl'}->Refresh(); 
        #}
    }    
    
    1;
}

#-------------------------- Rest in peace functions -----------------------


##
# I'm the death bringer method!
##

sub Destroy{
    my ($self) = @_;
    
    if (defined $self->{FILTERHANDLER}) {
       $self->{FILTERHANDLER} = undef;
       delete $self->{FILTERHANDLER};   
    }
    if (defined $self->{FIND}) {
       $self->{FIND} = undef;
       delete $self->{FIND};        
    }
    
    #
    #   Destroy Sizer
    #
    
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #

    foreach my $element (  
                        
                        'content_tree',
                        #'content_textctrl',
                        'content_details_tree',
                        
                        'simple_textctrl',
                        'simplesearch_label',
                        'simplesearch_textctrl',
                        'simplesearch_next_button',
                        'simplesearch_previous_button',
                        'simplesearch_matchcase_checkbox',
                        
                        'search_label',
                        'search_textctrl',
                        'search_next_button',
                        'search_previous_button',
                        'search_highlightall_button',
                        'search_matchcase_checkbox',
                        'filter_list',
                        'filter_combo',
                        'filter_button',
                        'delete_button',
                        'delete_all_button',
                        'disEnable_checkbox',
                        
                        'msg_label',
                        'masterline',
                        'load_button',
                        'exit_button',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
    $self->SUPER::Destroy;
}

1;
