package SDB::Install::SAPControl::Process;

use strict;
use parent 'SDB::Install::Base';

use constant {
    PROCESS_STATE_RUNNING   => 'Running',
    PROCESS_STATE_STOPPED   => 'Stopped',
    PROCESS_STATE_UNKNOWN   => 'Unknown',
};

sub new {
    my ($class, $xmlData) = @_;
    my $self = bless($xmlData, $class);

    return $self;
}

sub getName {
    my ($self) = @_;
    return $self->{name};
}

sub getDisplayName {
    my ($self) = @_;
    my $name = $self->getName();
    if ($self->isTenantProcess()) {
        my $tenantName = $self->getProcessTenant();
        return "$name ($tenantName)";
    }
    return $name;
}

sub getDescription {
    my ($self) = @_;
    return $self->{description};
}

sub getDispstatus {
    my ($self) = @_;
    return $self->{dispstatus} =~ s/^SAPControl-//r;
}

sub getTextstatus {
    my ($self) = @_;
    return $self->{textstatus} // PROCESS_STATE_UNKNOWN;
}

sub getStarttime {
    my ($self) = @_;
    return $self->{starttime};
}

sub getElapsedtime {
    my ($self) = @_;
    return $self->{elapsedtime};
}

sub getPid {
    my ($self) = @_;
    return $self->{pid};
}

sub getProcessTenant {
    my ($self) = @_;
    my $description = $self->getDescription();
    if ($description =~ /^[\w\s]+-(\S+)$/) {
        return $1;
    }

    return undef;
}

sub isTenantProcess {
    my ($self) = @_;
    return defined($self->getProcessTenant()) ? 1 : 0;
}

sub isRunning {
    my ($self) = @_;
    return $self->getTextstatus() eq PROCESS_STATE_RUNNING ? 1 : 0;
}

sub isStopped {
    my ($self) = @_;
    return $self->getTextstatus() eq PROCESS_STATE_STOPPED ? 1 : 0;
}

sub asString {
    my ($self) = @_;
    my $name = $self->getDisplayName();
    my $status = $self->getTextstatus();
    return "$name - $status";
}

1;