package SDB::Install::SAPInstance::Services::UnregisterHostRoleService;

use strict;
use warnings;

use SDB::Install::Globals qw ( $gHostRoleXS2Worker $gHostRoleWorker
                               $gHostRoleXS2Standby $gHostRoleStandby
                               getXS2ServiceNames );
use SDB::Install::SAPControl;

use parent qw(SDB::Install::Base);

use constant SAPCONTROL_TIMEOUT=>50;
use constant SAPCONTROL_SLEEP=>5;

sub new{
    my ($class,$sapInstance) = @_;
    my $self={};
    bless($self,$class);
    $self->{_sapInstance}=$sapInstance;
    return $self;
}

sub getSAPInstance{
    my $self = shift;
    return $self->{_sapInstance};
}

sub unregisterHostRole{
     my ($self, $host, $role, $force, $configuration) = @_;

    my $instance=$self->getSAPInstance();
    if (!defined $force){
        $force = 0;
    }

    my $nameserverUtility = $self->getNameserverUtility();
    $nameserverUtility->setMsgLstContext($self->getMsgLstContext());
    my $rc = $nameserverUtility->removeHostRole($host, $role, $force);
    if (!defined $rc){
        return $rc;
    }
    if($rc && $role eq $gHostRoleXS2Worker && !$self->waitForXSServicesToStop($host,$configuration)){
        $rc = undef if(!$force);
        $self->getMsgLst()->addMessage('Skipping errors due to force option');
    }
    my $isUnregisteringXS2Role = $role eq $gHostRoleXS2Worker || $role eq $gHostRoleXS2Standby;
    my $leftoverHostRoles = $instance->getHostRolesByIniFile($host);
    my $isDbHost = grep {$_ =~ /$gHostRoleWorker|$gHostRoleStandby/} @$leftoverHostRoles;
    $instance->setMsgLstContext($self->getMsgLstContext());
    if($rc && $isUnregisteringXS2Role && !$isDbHost && !$instance->deleteXSSpaceIsolationUsers($configuration, $configuration->getSID())){
        $rc = undef if(!$force);
        $self->getMsgLst()->addMessage('Skipping errors due to force option');
    }
    if($rc && $isUnregisteringXS2Role && !$isDbHost && !$instance->deleteXsEaDataPath($configuration, $host)){
        $rc = undef if(!$force);
        $self->getMsgLst()->addMessage('Skipping errors due to force option');
    }
    return $rc;

}

sub waitForXSServicesToStop{
    my ($self,$host,$configuration) = @_;
    my $sapcontrol = $self->getSAPControl($host,$configuration);
    $sapcontrol->setMsgLstContext($self->getMsgLstContext());
    return $sapcontrol->WaitforStopped(SAPCONTROL_TIMEOUT, SAPCONTROL_SLEEP, getXS2ServiceNames());;
}

sub getNameserverUtility{
    my $self = shift;
    if(defined $self->{_nameServerUtility}){
        return $self->{_nameServerUtility};
    }
    my $nameserverUtility = $self->getSAPInstance()->getNameServerUtility();
    $self->setNameserverUtility($nameserverUtility);
    return $nameserverUtility;
}

sub setNameserverUtility{
    my ($self,$nameserverUtility) = @_;
    $self->{_nameServerUtility} = $nameserverUtility;
}

sub getSAPControl{
    my ($self,$host,$configuration) = @_;
    my $instanceNumber =  $self->getSAPInstance()->get_nr();
    return new SDB::Install::SAPControl($host,
                                        $instanceNumber,
                                        undef, # user
                                        undef, # password,
                                        $configuration->isUseHttps(),
                                        $configuration->getValue ('SSOCertificate'));
}
1;
