package SDB::Install::SAPSystemContainerHelper::InitialStartContainerHelper;

use strict;
use SDB::Install::SAPSystemUtilities;
use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::IOHelper;
use SDB::Install::SysInfo;
use SDB::Install::OSConfig;
use SDB::Install::SAPInstance::TrexInstance;
use SDB::Install::SAPSystem;

our @ISA = qw (SDB::Install::Base SDB::Install::SAPSystemUtilities);


sub performContainerAction {
    my ($self, $instconfig, $sapSys) = @_;
    my $msglst = $self->getMsgLst();
    my $instance = $sapSys->getNewDBInstances()->[0];
    my $importContent = $instconfig->getValue('ImportContent');
    my $tenantPassword= $instconfig->getValue('DefaultTenantSystemUserPassword');
    my $systemPassword = $instconfig->getValue('SystemUserPassword');
    my $createTenant = $instconfig->getValue('CreateInitialTenant');
    my $msg = $msglst->addProgressMessage ("Starting sapstartsrv...");
    $instance->setMsgLstContext ([$msg->getSubMsgLst()]);
    if (!defined $instance->startLocalSapStartSrv (undef,
                              $instconfig->getTimeout ('start_service'),
                              $instconfig->isUseHttps())){
        $self->setErrorMessage ("Cannot start sapstartsrv", $instance->getErrMsgLst ());
        return undef;
    }

    $instance->setMsgLstContext ([$msglst]);
    if (!defined $instance->startHost (undef, undef, undef,
                              $instconfig->getTimeout ('start_instance'))){
        $self->setErrorMessage ("Cannot start instance", $instance->getErrMsgLst ());
        return undef;
    }

    if( (not defined $createTenant) || $createTenant) {
        $msg = $msglst->addProgressMessage ("Creating initial tenant...");
        $instance->setMsgLstContext([$msg->getSubMsgLst ()]);
        my $tenantPort = $instconfig->getValue('TenantPort');
        if (!defined $instance->createInitialTenant ('SYSTEM', $systemPassword, $tenantPassword, undef, $tenantPort)){
            $self->setErrorMessage ("Cannot create initial tenant", $instance->getErrMsgLst());
            return undef;
        }
    }

    if ($importContent){
        $instance->setMsgLstContext([$msglst]);
        $instconfig->{params}->{SystemUser}->{value} = 'SYSTEM';
        $instconfig->{params}->{SQLSysPasswd}->{value} = $systemPassword;
        if (!defined $instance->importDeliveryUnits ($instconfig)){
            $self->setErrorMessage ("Cannot import delivery units", $instance->getErrMsgLst());
            return undef;
        }
    }

    return 1;
}

1;
