package SDB::Install::SSH::BaseSession;

use strict;
use warnings;

use parent 'SDB::Install::Base';


sub connect {
    my ($self, $hostname) = @_;
    return undef;
}

sub reconnect {
    my ($self, $max_retries) = @_;
    my $hostname = $self->getHostname();
    if (!defined $hostname) {
        $self->appendErrorMessage("There is no hostname specified to connect\n");
        return undef;
    }
    $max_retries //= 3;
    for my $try (1..$max_retries) {
        $self->getMsgLst()->addMessage("Reconnecting to host '$hostname' (try $try of $max_retries)");
        $self->{session} = $self->_createSession();
        next if !$self->connect($hostname);
        next if (!$self->authKey(1) && !$self->authPassword());
        return 1;
    }
    return undef;
}

sub authOk {
    ...
}

sub authKey {
    ...
}

sub authPassword {
    ...
}

sub _createSession {
    ...
}

sub getHostname {
    my ($self) = @_;
    return $self->{hostname};
}

sub setHostname {
    my ($self, $hostname) = @_;
    $self->{hostname} = $hostname;
}

sub getUsername {
    my ($self) = @_;
    return $self->{_user};
}

sub setUsername {
    my ($self, $value) = @_;
    $self->{_user} = $value if defined($value);
}

sub getPassword {
    my ($self) = @_;
    return $self->{_password};
}

sub setPassword {
    my ($self, $value) = @_;
    $self->{_password} = $value if defined($value);
}

sub getPublicKey {
    my ($self) = @_;
    return $self->{_pubkey};
}

sub setPublicKey {
    my ($self, $value) = @_;
    $self->{_pubkey} = $value if defined($value);
}

sub getPrivateKey {
    my ($self) = @_;
    return $self->{_privkey};
}

sub setPrivateKey {
    my ($self, $value) = @_;
    $self->{_privkey} = $value if defined($value);
}

sub getPassphrase {
    my ($self) = @_;
    return $self->{_passphrase};
}

sub setPassphrase {
    my ($self, $value) = @_;
    $self->{_passphrase} = $value if defined($value);
}

sub getStdinBuffer {
    my ($self) = @_;
    return $self->{stdinBuffer};
}

sub setStdinBuffer {
    my ($self, $data) = @_;
    $self->{stdinBuffer} = $data;
}

sub isEmptyInputBuffer {
    my ($self) = @_;
    my $buffer = $self->{stdinBuffer};
    return !defined($buffer) || !scalar(@$buffer);
}

sub getSftp {
    my ($self) = @_;
    return $self->{sftp};
}

sub setSftp {
    my ($self, $sftp) = @_;
    $self->{sftp} = $sftp;
}

sub getSftpConnection {
    my ($self) = @_;
    if (!$self->openSftp()) {
        $self->appendErrorMessage("Could not open SFTP connection on host '". $self->getHostname()."': " . $self->sessionError());
        return undef;
    }
    return $self->getSftp();
}

sub executeCommand {
    ...
}

sub _writeToChannel {
    my ($self, $data) = @_;
    return undef;
}

sub write {
    my ($self, $string) = @_;

    if (defined($string)) {
        return $self->_writeToChannel($string);
    }
    my $stdinBuffer = $self->getStdinBuffer();
    if ($self->isEmptyInputBuffer($stdinBuffer)) {
        return undef;
    }
    if ($self->_writeToChannel($stdinBuffer->[0])) {
        shift(@$stdinBuffer);
        if ($self->isEmptyInputBuffer()) {
            $self->sendEof();
        }
        return 0;
    }
    return -1;
}

sub getOutput {
    ...
}

sub getOutputBuffer {
    my ($self) = @_;
    $self->{outputBuffer} //= '';
    return $self->{outputBuffer};
}

sub deleteOutputBuffer {
    my ($self) = @_;
    delete $self->{outputBuffer};
}

sub appendToOutputBuffer {
    my ($self, $output) = @_;
    $output //= '';
    $self->{outputBuffer} .= $output;
}

sub sendEof {
    my ($self) = @_;
    return undef;
}

sub exitChannel {
    my ($self) = @_;
    return undef;
}

sub generateSSHKeys {
    ...
}

sub isDirectory {
    ...
}

sub isRegularFile {
    ...
}

sub isEntryToSkip {
    my ($self, $entry) = @_;
    return 1 if (!defined($entry));
    return ($entry->{name} eq '.' || $entry->{name} eq '..');
}

sub checkFileType {
    my ($self, $path, $stat, $shouldBeDir, $msglst) = @_;
    my $hostname = $self->getHostname();
    if ($shouldBeDir && !$self->isDirectory($stat)) {
        $msglst->appendErrorMessage("'$path' is not a directory on host '$hostname'");
        return 0;
    }
    if (!$shouldBeDir && !$self->isRegularFile($stat)) {
        $msglst->appendErrorMessage("File '$path' is no regular file on host '$hostname'");
        return 0;
    }
    return 1;
}

sub _appendAuthKeyErrorMsg {
    my ($self, $error, $ignoreError, $msglst) = @_;
    $msglst //= $self;
    my $msg = sprintf ("Public key authentication for host '%s' failed: " . $error, $self->getHostname());
    if ($ignoreError) {
        $msglst->getMsgLst()->addMessage($msg);
    } else {
        $msglst->appendErrorMessage($msg);
    }
}

sub _appendAuthPassErrorMsg {
    my ($self, $error, $msglst) = @_;
    $msglst //= $self;
    my $msg = sprintf ("Password authorization on host '%s' failed: " . $error, $self->getHostname());
    $msglst->appendErrorMessage($msg);
}

sub _appendSftpError {
    my ($self, $msg, $msglst) = @_;
    $msglst //= $self;
    my $sftpError = $self->sftpError();
    $msglst->appendErrorMessage($msg . ($sftpError ? ": $sftpError" : ''));
}

1;
