package SDB::Install::ServerPluginOnlineOperation::AflOnlineOperation;

use strict;
use warnings;

use base 'SDB::Install::ServerPluginOnlineOperation';

our $ACTION_STRING                = 'afl operation';
our $SQL_CLEANUP                  = 'CALL SYS.AFLPM_ONLINE_REGISTRATION_CLEANUP ()';
our $SQL_ROLE_ONLINE_REGISTRATION = 'AFLPM_ONLINE_REGISTRATION_EXECUTE';

sub new{
    my ($class, $pluginKey, $pluginManifest) = @_;
    my $self = $class->SUPER::new($pluginKey, $pluginManifest);
    return $self;
}

sub _getAction{
    return $ACTION_STRING;
}

sub _dbProcExists{
    my ($self, $procName,$msglst) = @_;
    $msglst = defined $msglst ? $msglst : $self->getMsgLst();
    my $schema = 'SYS';
    my $fullProcName = $procName;
    if ($procName =~ /\./){
        ($schema,$procName) = split(/\./, $procName);
    }
    else{
        $fullProcName = "$schema.$procName";
    }
    my $msg = $msglst->addMessage("Checking whether procedure '$fullProcName' exists");
    $msglst = $msg->getSubMsgLst();
    # use prep statement when procName is supplied externally:
    my $stmnt = "SELECT COUNT(PROCEDURE_NAME) FROM $schema.PROCEDURES WHERE PROCEDURE_NAME = '$procName'";
    my $sql = $self->{sqlConnection};
    $sql->setMsgLstContext([$msglst]);
    if (!defined $sql->execute($stmnt)){
        $self->setErrorMessage ("Execution of '$stmnt' failed", $sql->getErrMsgLst ());
        return undef;
    }
    my $result = $sql->getResultSet();
    if (!defined $result){
        $self->setErrorMessage('getResultSet failed', $sql->getErrMsgLst ());
        return undef;
    }
    if ($result->[0]->[0] > 0){
        $msglst->addMessage("Procedure '$fullProcName' exists.");
        return 1;
    }
    $msglst->addMessage("Procedure '$fullProcName' doesn't exist.");
    return 0;
}

sub checkSqlUser{
    my ($self) = @_;
    return $self->_checkSqlUserPrivilegesByRole($SQL_ROLE_ONLINE_REGISTRATION);
}

sub cleanup{
    my ($self) = @_;
    if (!defined $self->{sqlConnection}){
        return 1;
    }
    if (!$self->{onlineOperationOk}){
        my $msg = $self->getMsgLst()->addProgressMessage(sprintf('Cleaning up failed online %s.', $self->_getAction()));
        my $sql = $self->{sqlConnection};
        $sql->setMsgLstContext([$msg->getSubMsgLst()]);
        if (!defined $sql->execute($SQL_CLEANUP)){
            $self->appendErrorMessage("Execution of '$SQL_CLEANUP' failed", $sql->getErrMsgLst ());
            $self->appendErrorMessage(sprintf('Server plugin online %s failed.', $self->_getAction()));
            $self->appendErrorMessage(sprintf('Please restart HANA Database manually to %s the plugin!', $self->_getAction()));
            delete $self->{sqlConnection};
            return undef;

        }
    }
    delete $self->{sqlConnection};
    return 1;
}

1;
